--
-- ScratchFloor3d.lua
-- play scratch floor animation when Trailer.TIPSTATE_OPENING,OPEN,CLOSING.
--
-- author: Brndi
-- date: 15.01.2013
-- version: v1.0 (January 2013)

-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!

ScratchFloor3d = {};

function ScratchFloor3d.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function ScratchFloor3d:load(xmlFile)	
	self.animation = {};
	self.animation.animCharSet = 0;
	self.outAnimation = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.outAnimation#node"));
  
	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.outAnimation#clipname"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.outAnimation#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
end;

function ScratchFloor3d:onDeactivate()
end;

function ScratchFloor3d:delete()
end;

function ScratchFloor3d:readStream(streamId, connection)
end;

function ScratchFloor3d:writeStream(streamId, connection)
end;

function ScratchFloor3d:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ScratchFloor3d:keyEvent(unicode, sym, modifier, isDown)
end;

function ScratchFloor3d:update(dt)
	if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN or self.tipState == Trailer.TIPSTATE_CLOSING then
		enableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = true;
	else
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
end;

function ScratchFloor3d:updateTick(dt)
end;

function ScratchFloor3d:draw()
end;

function ScratchFloor3d:onDetach()
end;