LightStateEvent = {};
LightStateEvent_mt = Class(LightStateEvent, Event);

InitEventClass(LightStateEvent, "LightStateEvent");

function LightStateEvent:emptyNew()
    local self = Event:new(LightStateEvent_mt);
    self.className="LightStateEvent";
    return self;
end;

function LightStateEvent:new(vehicle, state)
    local self = LightStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.lightState = state;
    return self;
end;

function LightStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.lightState = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function LightStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.lightState);
end;

function LightStateEvent:run(connection)
	self.vehicle:setLightState(self.lightState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(LightStateEvent:new(self.vehicle, self.lightState), nil, connection, self.vehicle);
    end;
end;


function LightStateEvent.sendEvent(vehicle, state, noEventSend)
	if vehicle.currentLight ~= state then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(LightStateEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(LightStateEvent:new(vehicle, state));
			end;
		end;
	end;
end;