OilTemp = {};

function OilTemp.prerequisitesPresent(specializations)
return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function OilTemp:load(xmlFile)
	self.oiltemp = 5;
	self.warmUp = 0.010;
	self.fuelType = "Diesel";
	self.fuelTimer = 0;
	self.backUpFuelUsage = self.fuelUsage;
	    self.zuendungKey = false;
	self.allowedZuendung = false;
		self.OilTempPanel = false;
end;

function OilTemp:delete()
end;

function OilTemp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OilTemp:keyEvent(unicode, sym, modifier, isDown)
if InputBinding.isPressed(InputBinding.STATS) then
	
	self.OilTempPanel = not self.OilTempPanel;
end;
end;
function OilTemp:update(dt)

	self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
    if InputBinding.isAxisZero(self.input) then
    	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;
	if self.motor.speedLevel ~= 0 then
	    self.input = 1;
	end;
	if self.isMotorStarted then
		local maxiRpm = self.motor:getMaxRpm();
		local lastiMotorRpm = self.motor.lastMotorRpm;
		local powerDifferenzi = ((100/lastiMotorRpm)*maxiRpm)-100;
		local sec = (dt/dt)/dt;
		if powerDifferenzi > 100 then
			powerDifferenzi = 100;
		elseif powerDifferenzi < 0 then
			powerDifferenzi = 0;
		end;
		if maxiRpm < self.motor.minRpm then
			maxiRpm = self.motor.minRpm;
		end;
		if lastiMotorRpm < 50 then
			lastiMotorRpm = self.motor.minRpm;
		end;
		if self.input == 0 or self.motor.speedLevel == 0 then
			if self.oiltemp < 95 then
				self.oiltemp = self.oiltemp+(4/lastiMotorRpm);
			else
				self.oiltemp = self.oiltemp-(4/lastiMotorRpm);
			end;
		end;
		if powerDifferenzi > 0 then
			self.oiltemp = self.oiltemp + (powerDifferenzi / 7000);
		end;
		if self.oiltemp > 100 then
			self.coolingOn = true;
		end;
		if self.coolingOn and self.oiltemp < 90 then
			self.coolingOn = false;
		end;
		if self.coolingOn then
			self.oiltemp = self.oiltemp-(8 / lastiMotorRpm);
		end;
		if lastiMotorRpm > self.motor.minRpm then
			self.fuelTimer = self.fuelTimer+sec;
		else
			self.fuelTimer = self.fuelTimer-sec;
		end;
		if self.fuelTimer > 20 then
			self.fuelTimer = 20;
		elseif self.fuelTimer < -10 then
			self.fuelTimer = -10;
		end;
	else
		self.oiltemp = self.oiltemp-self.warmUp;
	end;
	if self.oiltemp < 5 then
		self.oiltemp = 5;
	end;
	if self.oiltemp > 60 then
		if self.fuelTimer > 0 then
			self.fuelType = "Rapsoil";
			self.fuelUsage = (self.fuelUsage/1);
		else
			self.fuelType = "Diesel";
			self.fuelUsage = self.backUpFuelUsage;
		end;
	else
		self.fuelType = "Diesel";
	end;
end;



function OilTemp:draw() 

     if self.OilTempPanel then  
        
          local red = 0.0; 
          local green = 0.0; 
          local blue = 0.0; 
          if self.oiltemp < 60 then
		red = 0.0;
		green = 0.0;
		blue = 1.0;
	elseif self.oiltemp >= 60 and self.oiltemp <= 110 then
		blue = 0.0;
		red = 0.0;
		green = 1.0;
	elseif self.oiltemp > 110 then
		red = 1.0;
		green = 0.0;
		blue = 0.0;
	end;
               setTextColor(red, green, blue, 1.0); 
          renderText(0.023, 0.12, 0.012, string.format("Motoroil Temperatur: %d C", self.oiltemp));
		  setTextColor(1 ,1 ,1 , 1);
		  renderText(0.023, 0.11, 0.012, string.format("Kraftstoff: %s", self.fuelType));
     
         
     end; 
end;



function OilTemp:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local loadTemp = getXMLFloat(xmlFile, key.."#oiltemp");
	if loadTemp ~= nil then
		self.oiltemp = loadTemp;
	end;
	return BaseMission.VEHICLE_LOAD_OK;


end;

function OilTemp:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'oiltemp="'..self.oiltemp..'"';
    return attributes, nil;
end;