--
-- ArticulatedSteering
-- Specialization for ArticulatedSteering
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  28/04/10
--

ArticulatedSteering = {};

function ArticulatedSteering.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations) and SpecializationUtil.hasSpecialization(AITractor, specializations);
end;

function ArticulatedSteering:load(xmlFile)
	
	self.articulatedSteering = {};	
	self.articulatedSteering.joint = getXMLInt(xmlFile, "vehicle.articulatedSteering#joint");
	if self.articulatedSteering.joint ~= nil then
		self.articulatedSteering.minRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.articulatedSteering#minRot"));
		self.articulatedSteering.maxRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.articulatedSteering#maxRot"));
		self.articulatedSteering.rotSpeed = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.articulatedSteering#rotSpeed"),40));
		self.articulatedSteering.curRot = 0;
		
		local maxRotTime = self.articulatedSteering.maxRot / self.articulatedSteering.rotSpeed;
		local minRotTime = self.articulatedSteering.minRot / self.articulatedSteering.rotSpeed;
		if minRotTime > maxRotTime then
			local temp = minRotTime;
			minRotTime = maxRotTime;
			maxRotTime = temp;
		end;

		self.maxRotTime = math.max(maxRotTime, self.maxRotTime);
		self.minRotTime = math.min(minRotTime, self.minRotTime);
		
		self.frameRotateTime = 0;
		self.doOnce = true;
		self.turningInProcess = false;
		self.aiBackUp = self.aiTractorDirectionNode;
	else
		print("Could not load articulated steering. Joint is nil");
	end;
end;

function ArticulatedSteering:delete()
end;

function ArticulatedSteering:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ArticulatedSteering:keyEvent(unicode, sym, modifier, isDown)
end;

function ArticulatedSteering:update(dt)

    if self:getIsActive() then
		if self.articulatedSteering.joint ~= nil then
			local steeringAngle = self.rotatedTime * self.articulatedSteering.rotSpeed;
			steeringAngle = math.max(math.min(steeringAngle, self.articulatedSteering.maxRot), self.articulatedSteering.minRot);
			local jointNode = self.componentJoints[self.articulatedSteering.joint].jointNode;
			local jointIndex = self.componentJoints[self.articulatedSteering.joint].jointIndex;
			setRotation(jointNode, 0, steeringAngle, 0);
			setJointFrame(jointIndex, 1, jointNode);
			self.articulatedSteering.curRot = steeringAngle;
			
			-- Turning Bug-Fix
			if self.turnStage ~= 0 and self.doOnce then	
				self.aiTractorDirectionNode = self.components[1].node;
				self.frameRotateTime = 100;
				self.turningInProcess = true;
				self.doOnce = false;
			end;			
			if self.turnStage == 0 and self.turningInProcess then
				self.frameRotateTime = self.frameRotateTime - dt;
			end;				
			if self.frameRotateTime <= 0 then
				self.doOnce = true;
				self.turningInProcess = false;
				self.aiTractorDirectionNode = self.aiBackUp;
				-- Fix excalating steering in helping modus
				setRotation(self.aiTractorDirectionNode, 0, -steeringAngle/2, 0);
			end;
		end;
    end;
end;

function ArticulatedSteering:draw()
end;
