actros = {}

function actros.prerequisitesPresent(specializations)
     Vehicle.registerJointType("shovel");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function actros:load(xmlFile)

     self.translationMin3 = true;
     self.translationMin4 = true;

    
    
    local rotationPartNodebras1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras1#index"));
    if rotationPartNodebras1 ~= nil then
        self.bras1 = {};
        self.bras1.node = rotationPartNodebras1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras1#minRot"));
        self.bras1.minRot = {};
        self.bras1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras1#maxRot"));
        self.bras1.maxRot = {};
        self.bras1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.bras1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bras1#rotTime"), 2)*1000;
     
     
	    self.bras1.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras1#pivotverin"));
    end;
    local translationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;
    local translationPartNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart4#index"));
    if translationPartNode4 ~= nil then
        self.translationPart4 = {};
        self.translationPart4.node = translationPartNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart4#minTrans"));
        self.translationPart4.minTrans = {};
        self.translationPart4.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart4.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart4.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart4#maxTrans"));
        self.translationPart4.maxTrans = {};
        self.translationPart4.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart4.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart4.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart4.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart4#transTime"), 2)*1000;
        self.translationPart4.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart4#touchTransLimit"), 10);
    end;
    
            local rotationPartNodetourelle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourelle#index"));
    if rotationPartNodetourelle ~= nil then
        self.tourelle = {};
        self.tourelle.node = rotationPartNodetourelle;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelle#minRot"));
        self.tourelle.minRot = {};
        self.tourelle.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelle.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelle.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelle#maxRot"));
        self.tourelle.maxRot = {};
        self.tourelle.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelle.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelle.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourelle.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelle#rotTime"), 2)*1000;
        self.tourelle.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelle#touchRotLimit"), 10))
    end;
        local rotationPartNodetourelle2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourelle2#index"));
    if rotationPartNodetourelle2 ~= nil then
        self.tourelle2 = {};
        self.tourelle2.node = rotationPartNodetourelle2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelle2#minRot"));
        self.tourelle2.minRot = {};
        self.tourelle2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelle2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelle2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelle2#maxRot"));
        self.tourelle2.maxRot = {};
        self.tourelle2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelle2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelle2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourelle2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelle2#rotTime"), 2)*1000;
        self.tourelle2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelle2#touchRotLimit"), 10))
    end;
    local rotationPartNodetourelle3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourelle3#index"));
    if rotationPartNodetourelle3 ~= nil then
        self.tourelle3 = {};
        self.tourelle3.node = rotationPartNodetourelle3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelle3#minRot"));
        self.tourelle3.minRot = {};
        self.tourelle3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelle3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelle3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelle3#maxRot"));
        self.tourelle3.maxRot = {};
        self.tourelle3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelle3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelle3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourelle3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelle3#rotTime"), 2)*1000;
        self.tourelle3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelle3#touchRotLimit"), 10))
    end;
    
        local rotationPartNodetourelle4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourelle4#index"));
    if rotationPartNodetourelle4 ~= nil then
        self.tourelle4 = {};
        self.tourelle4.node = rotationPartNodetourelle4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelle4#minRot"));
        self.tourelle4.minRot = {};
        self.tourelle4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelle4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelle4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelle4#maxRot"));
        self.tourelle4.maxRot = {};
        self.tourelle4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelle4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelle4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourelle4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelle4#rotTime"), 2)*1000;
        self.tourelle4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelle4#touchRotLimit"), 10))
    end;
    
        local rotationPartNodetourelleporte1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourelleporte1#index"));
    if rotationPartNodetourelleporte1 ~= nil then
        self.tourelleporte1 = {};
        self.tourelleporte1.node = rotationPartNodetourelleporte1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelleporte1#minRot"));
        self.tourelleporte1.minRot = {};
        self.tourelleporte1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelleporte1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelleporte1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelleporte1#maxRot"));
        self.tourelleporte1.maxRot = {};
        self.tourelleporte1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelleporte1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelleporte1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourelleporte1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelleporte1#rotTime"), 2)*1000;
        self.tourelleporte1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelleporte1#touchRotLimit"), 10))
    end;

    local rotationPartNodetourelleporte2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tourelleporte2#index"));
    if rotationPartNodetourelleporte2 ~= nil then
        self.tourelleporte2 = {};
        self.tourelleporte2.node = rotationPartNodetourelleporte2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelleporte2#minRot"));
        self.tourelleporte2.minRot = {};
        self.tourelleporte2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelleporte2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelleporte2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tourelleporte2#maxRot"));
        self.tourelleporte2.maxRot = {};
        self.tourelleporte2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tourelleporte2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tourelleporte2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tourelleporte2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelleporte2#rotTime"), 2)*1000;
        self.tourelleporte2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tourelleporte2#touchRotLimit"), 10))
    end;
    
    
    
        local rotationPartNodebras2= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras2#index"));
    if rotationPartNodebras2 ~= nil then
        self.bras2 = {};
        self.bras2.node = rotationPartNodebras2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras2#minRot"));
        self.bras2.minRot = {};
        self.bras2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras2#maxRot"));
        self.bras2.maxRot = {};
        self.bras2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.bras2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bras2#rotTime"), 2)*1000;


	    self.bras2.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras2#pivotverin"));
    end;
    
    self.verin1 = {};
	self.verin1.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indexverin"));
	self.verin1.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indextige"));
	self.verin1.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin1.tige);
    local bx, by, bz = getWorldTranslation(self.verin1.translationtige);
    self.verin1.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
    
        self.verin2 = {};
	self.verin2.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#indexverin"));
	self.verin2.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#indextige"));
	self.verin2.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin2#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin2.tige);
    local bx, by, bz = getWorldTranslation(self.verin2.translationtige);
    self.verin2.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
  


end;

function actros:delete()

end;


function actros:mouseEvent(posX, posY, isDown, isUp, button)
end;

function actros:keyEvent(unicode, sym, modifier, isDown)  

	if self.isEntered and self.isMotorStarted then
	
	if sym == Input.KEY_KP_4 then
		self.rotationMintourelle = isDown;
		self.rotationMintourelle2 = isDown;
		self.rotationMintourelle3 = isDown;
		self.rotationMintourelle4 = isDown;
		self.translationMin4 = isDown;
         end;
	if sym == Input.KEY_KP_7 then
		self.rotationMaxtourelle = isDown;
		self.rotationMaxtourelle2 = isDown;
	    self.rotationMaxtourelle3 = isDown;
	    self.rotationMaxtourelle4 = isDown;
	    self.translationMax4 = isDown;
        end;
    if sym == Input.KEY_KP_5 then
    self.rotationMintourelleporte1 = isDown;
    self.rotationMintourelleporte2 = isDown;
	end;
	if sym == Input.KEY_KP_8 then
    self.rotationMaxtourelleporte1 = isDown;
    self.rotationMaxtourelleporte2 = isDown;
	end;
  end;


  
end;


function actros:update(dt)

	self.bras1Moving = 0; 
	self.bras2Moving = 0;
	
	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
	
	
	
	if self: getIsActiveForInput() then

		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.translationMax3 = not self.translationMax3;
		end;
	end;
		
	
	if self.translationMax3 ~= nil then
		local x, y, z = getTranslation(self.translationPart3.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
        setTranslation(self.translationPart3.node, unpack(newTrans));
	end;
	if self.translationMax4 ~= nil then
		local x, y, z = getTranslation(self.translationPart4.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart4.maxTrans, self.translationPart4.minTrans, 3, self.translationPart4.transTime, dt, not self.translationMax4);
        setTranslation(self.translationPart4.node, unpack(newTrans));
	end;
	
		     local doRotate = self.rotationMaxtourelle or self.rotationMintourelle
    	if self.tourelle ~= nil and doRotate then
		local x, y, z = getRotation(self.tourelle.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourelle.maxRot, self.tourelle.minRot, 3, self.tourelle.rotTime, dt, not self.rotationMaxtourelle);
		setRotation(self.tourelle.node, unpack(newRot));		
	end;
	     local doRotate = self.rotationMaxtourelle2 or self.rotationMintourelle2
    	if self.tourelle2 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourelle2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourelle2.maxRot, self.tourelle2.minRot, 3, self.tourelle2.rotTime, dt, not self.rotationMaxtourelle2);
		setRotation(self.tourelle2.node, unpack(newRot));		
	end;
		     local doRotate = self.rotationMaxtourelle3 or self.rotationMintourelle3
    	if self.tourelle3 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourelle3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourelle3.maxRot, self.tourelle3.minRot, 3, self.tourelle3.rotTime, dt, not self.rotationMaxtourelle3);
		setRotation(self.tourelle3.node, unpack(newRot));		
	end;
	
			     local doRotate = self.rotationMaxtourelle4 or self.rotationMintourelle4
    	if self.tourelle4 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourelle4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourelle4.maxRot, self.tourelle4.minRot, 3, self.tourelle4.rotTime, dt, not self.rotationMaxtourelle4);
		setRotation(self.tourelle4.node, unpack(newRot));
	end;
	
		local doRotate = self.rotationMaxtourelleporte2 or self.rotationMintourelleporte2
    	if self.tourelleporte2 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourelleporte2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourelleporte2.maxRot, self.tourelleporte2.minRot, 3, self.tourelleporte2.rotTime, dt, not self.rotationMaxtourelleporte2);
		setRotation(self.tourelleporte2.node, unpack(newRot));
	end;

	local doRotate = self.rotationMaxtourelleporte1 or self.rotationMintourelleporte1
    	if self.tourelleporte1 ~= nil and doRotate then
		local x, y, z = getRotation(self.tourelleporte1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.tourelleporte1.maxRot, self.tourelleporte1.minRot, 3, self.tourelleporte1.rotTime, dt, not self.rotationMaxtourelleporte1);
		setRotation(self.tourelleporte1.node, unpack(newRot));
	end;
	 
	
           	local doRotate = self.rotationMaxbras1 or self.rotationMinbras1
    	if self.bras1 ~= nil and doRotate then
		local x, y, z = getRotation(self.bras1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.bras1.maxRot, self.bras1.minRot, 3, self.bras1.rotTime, dt, not self.rotationMaxbras1);
		setRotation(self.bras1.node, unpack(newRot));
		
	end;
	           	local doRotate = self.rotationMaxbras2 or self.rotationMinbras2
    	if self.bras2 ~= nil and doRotate then
		local x, y, z = getRotation(self.bras2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.bras2.maxRot, self.bras2.minRot, 3, self.bras2.rotTime, dt, not self.rotationMaxbras2);
		setRotation(self.bras2.node, unpack(newRot));

	end;
   	if self.verin1 ~= nil and self.bras1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin1.node);
		local bx, by, bz = getWorldTranslation(self.bras1.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin1.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin1.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin1.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin1.tige, 0, 0, (distance-self.verin1.tigeDistance)*-1);
		end;
	end;
	   	if self.verin2 ~= nil and self.bras2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin2.node);
		local bx, by, bz = getWorldTranslation(self.bras2.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin2.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin2.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin2.tige, 0, 0, (distance-self.verin2.tigeDistance)*-1);
		end;
	end;

end;
      


function actros:draw()

g_currentMission:addExtraPrintText("Touche KP_7/KP_4: Lever/descendre benne");
g_currentMission:addExtraPrintText("Touche KP_8/KP_5: Ouvrir/fermer portes");



end;
