--
-- Specialization CattleTrailer
-- This script select the TipAnimation/TipReferencePoint based on the fruitType/fillType
--
--
-- @author:		Jengske_BE  (www.international-modding.eu)
-- @email:		ponystal-peeters@telenet.be
-- @version:	v1.0
-- @date:		22/01/14
-- @history:	v1.0 - inital implementation
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.


CattleTrailer = {};
local mod_directory = g_currentModDirectory;
source(Utils.getFilename("scripts/CTrailerTipAreaEvent.lua", mod_directory));
source(Utils.getFilename("scripts/CTrailerToggleTipEvent.lua", mod_directory));
CattleTrailer.TIPSTATE_CLOSED = 0;
CattleTrailer.TIPSTATE_OPENING = 1;
CattleTrailer.TIPSTATE_OPEN = 2;
CattleTrailer.TIPSTATE_CLOSING = 3;


function CattleTrailer.prerequisitesPresent(specializations)
   return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;


function CattleTrailer:load(xmlFile)
    print("--- loading CattleTrailer - specialization by Jengske_BE (www.international-modding.eu)");
        self.toggleTipState = SpecializationUtil.callSpecializationsFunction("toggleTipState");
        self.onStartTip = SpecializationUtil.callSpecializationsFunction("onStartTip");
        self.onEndTip = SpecializationUtil.callSpecializationsFunction("onEndTip");
        self.enableTipAnimation = SpecializationUtil.callSpecializationsFunction("enableTipAnimation");
        self.disableCurrentTipAnimation = SpecializationUtil.callSpecializationsFunction("disableCurrentTipAnimation");
        self.setCurrentTipAnimationTime = SpecializationUtil.callSpecializationsFunction("setCurrentTipAnimationTime");
        self.getCurrentTipAnimationTime = CattleTrailer.getCurrentTipAnimationTime;
        self.getCurrentTipAnimationDuration = CattleTrailer.getCurrentTipAnimationDuration;
        self.setFillLevel = Utils.prependedFunction(self.setFillLevel, CattleTrailer.setFillLevel);
        self.getCurrentFruitType = CattleTrailer.getCurrentFruitType;
        self.updateTipping = CattleTrailer.updateTipping;
        self.getCanTipToGround = CattleTrailer.getCanTipToGround;
        self.getCanTip = CattleTrailer.getCanTip;
		self.capacity = 5000;
		
        self.tipText = Utils.getXMLI18NValue(xmlFile, "vehicle", getXMLString, "tipText", g_i18n:getText("Dump"), self.customEnvironment, false);


        self.lastFillDelta = 0;

        self.tipAnimations = {};
        local i = 0;
        while true do
            local key = string.format("vehicle.tipAnimations.tipAnimation(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
                break;
            end

            local tipAnimation = {};
            tipAnimation.dischargeEndTime = getXMLFloat(xmlFile, key.."#dischargeEndTime");
            if tipAnimation.dischargeEndTime ~= nil then
               tipAnimation.dischargeEndTime = tipAnimation.dischargeEndTime * 1000;
            end
            tipAnimation.dischargeStartTime = Utils.getNoNil(getXMLFloat(xmlFile, key.."#dischargeStartTime"), 0)*1000;
            local animationName = getXMLString(xmlFile, key.."#animationName");

            tipAnimation.animationOpenSpeedScale = getXMLFloat(xmlFile, key.."#openSpeedScale");
            tipAnimation.animationCloseSpeedScale = getXMLFloat(xmlFile, key.."#closeSpeedScale");

            local speedScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speedScale"), 1);
            if tipAnimation.animationOpenSpeedScale == nil then
                tipAnimation.animationOpenSpeedScale = speedScale;
            end
            if tipAnimation.animationCloseSpeedScale == nil then
                tipAnimation.animationCloseSpeedScale = -speedScale;
            end

            if animationName ~= nil then
                if self.playAnimation ~= nil and self.getAnimationDuration ~= nil then
                  tipAnimation.animationName = animationName;
                   tipAnimation.animationDuration = self:getAnimationDuration(animationName);
               else
                   print("Error: tip animation "..i.." has animation name, but misses specialization AnimatedVehicle in "..self.configFileName);
              end
           else
               local animationRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#rootNode"));
                if animationRootNode ~= nil then
                    local animationCharSet = getAnimCharacterSet(animationRootNode);
                    if animationCharSet ~= nil then
                        local clip = getAnimClipIndex(animationCharSet, getXMLString(xmlFile, key.."#clip"));
                       assignAnimTrackClip(animationCharSet, 0, clip);
                       setAnimTrackLoopState(animationCharSet, 0, false);

                        tipAnimation.animationCharSet = animationCharSet;
                        tipAnimation.animationDuration = getAnimClipDuration(animationCharSet, clip);
                    end
                end
            end
            if tipAnimation.dischargeEndTime == nil and tipAnimation.animationDuration ~= nil then
                tipAnimation.dischargeEndTime = tipAnimation.animationDuration*2.0;
            end
            if tipAnimation.dischargeEndTime ~= nil then
               if self.isClient then
                   tipAnimation.dischargeParticleSystems = {};
                   local i = 0;
                   while true do
                       local keyPS = string.format(key..".dischargeParticleSystems.dischargeParticleSystem(%d)", i);
                       local t = getXMLString(xmlFile, keyPS .. "#type");
                     if t == nil then
                          break;
                      end;
                      local fillType = Fillable.fillTypeNameToInt[t];
                       if fillType ~= nil then
                           local currentPS = {};
                           local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, keyPS, self.components, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
                           tipAnimation.dischargeParticleSystems[fillType] = currentPS;
                      end;
                      i = i + 1;
                  end;
              end

              table.insert(self.tipAnimations, tipAnimation);
           else
               print("Error: invalid tip animation "..i.." in "..self.configFileName);
          end
          i = i + 1;
      end

      -- Fallback for old tipAnimation and tipDischargeEndTime
      if table.getn(self.tipAnimations) == 0 then
          local tipAnimation = {};
          tipAnimation.dischargeEndTime = getXMLFloat(xmlFile, "vehicle.tipDischargeEndTime#value");
           tipAnimation.dischargeStartTime = 0;

          local animationRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tipAnimation#rootNode"));
          if animationRootNode ~= nil then
              local animationCharSet = getAnimCharacterSet(animationRootNode);
              if animationCharSet ~= 0 then

                  local clip = getAnimClipIndex(animationCharSet, getXMLString(xmlFile, "vehicle.tipAnimation#clip"));
                  assignAnimTrackClip(animationCharSet, 0, clip);
                  setAnimTrackLoopState(animationCharSet, 0, false);

                  tipAnimation.animationOpenSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tipAnimation#speedScale"), 1);
                  tipAnimation.animationCloseSpeedScale = -tipAnimation.animationOpenSpeedScale;
                  tipAnimation.animationCharSet = animationCharSet;
                  tipAnimation.animationDuration = getAnimClipDuration(animationCharSet, clip);
                  if tipAnimation.dischargeEndTime == nil then
                      tipAnimation.dischargeEndTime = tipAnimation.animationDuration*2.0;
                  end
              end
          end

           if tipAnimation.dischargeEndTime ~= nil then
              if self.isClient then
                  tipAnimation.dischargeParticleSystems = {};
                  local i = 0;
                   while true do
                       local keyPS = string.format("vehicle.dischargeParticleSystems.dischargeParticleSystem(%d)", i);
                       local t = getXMLString(xmlFile, keyPS .. "#type");
                       if t == nil then
                           break;
                       end;
                       local fillType = Fillable.fillTypeNameToInt[t];
                       if fillType ~= nil then
                           local currentPS = {};
                           local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, keyPS, self.components, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
                           tipAnimation.dischargeParticleSystems[fillType] = currentPS;
                       end;
                      i = i + 1;
                   end;
               end

               table.insert(self.tipAnimations, tipAnimation);
           end
       end
       self.tipState = CattleTrailer.TIPSTATE_CLOSED;

       self.fillLevelToTippedFillLevel = 1;

       self.tipReferencePoints = {};
       local i = 0;
       while true do
           local key = string.format("vehicle.tipReferencePoints.tipReferencePoint(%d)", i);
           if not hasXMLProperty(xmlFile, key) then
               break;
          end

          node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
           if node ~= nil then
               local width = Utils.getNoNil(getXMLFloat(xmlFile, key.."#width"), 0);
               table.insert(self.tipReferencePoints, {node=node, width=width});
           end
           i = i + 1;
       end

       -- Fallback for old tipReferencePoint
      if table.getn(self.tipReferencePoints) == 0 then
          local tipReferencePoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tipReferencePoint#index"));
          if tipReferencePoint == nil then
               tipReferencePoint = self.components[1].node;
           end
           table.insert(self.tipReferencePoints, {node=tipReferencePoint, width=0});
       end

       if self.isClient then

          self.hydraulicSoundEnabled = false;
          local hydraulicSound = getXMLString(xmlFile, "vehicle.hydraulicSound#file");
           if hydraulicSound ~= nil and hydraulicSound ~= "" then
               hydraulicSound  = Utils.getFilename(hydraulicSound, self.baseDirectory);
               self.hydraulicSound = createSample("hydraulicSound");
               loadSample(self.hydraulicSound, hydraulicSound, false);
               self.hydraulicSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#pitchOffset"), 1.0);
               self.hydraulicSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulicSound#volume"), 1.0);
               setSamplePitch(self.hydraulicSound, self.hydraulicSoundPitchOffset);
          end;

           self.fillSoundEnabled = false;
           local fillSound = getXMLString(xmlFile, "vehicle.fillSound#file");
           if fillSound ~= nil and fillSound ~= "" then
               fillSound  = Utils.getFilename(fillSound, self.baseDirectory);
               self.fillSound = createSample("fillSound");
               loadSample(self.fillSound, fillSound, false);
               self.fillSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSound#pitchOffset"), 1.0);
               self.fillSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSound#volume"), 1.0);
               setSamplePitch(self.fillSound, self.fillSoundPitchOffset);
           end;

           self.tipRotationNodes = {};
           local i = 0;
           while true do
              local key = string.format("vehicle.tipRotationNodes.tipRotationNode(%d)", i);
              if not hasXMLProperty(xmlFile, key) then
                  break;
              end;
              local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
              local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key.."#rotSpeed"), 1)*0.001);
              if node ~= nil then
                  table.insert(self.tipRotationNodes, {node=node, rotSpeed=rotSpeed});
              end;
              i = i + 1;
           end;

           self.tipScrollers = {};
          local i = 0;
          while true do
              local key = string.format("vehicle.tipScrollerNodes.tipScrollerNode(%d)", i);
              if not hasXMLProperty(xmlFile, key) then
                  break;
              end;
              local shaderParameter = getXMLString(xmlFile, "vehicle.tipScrollerNodes#shaderParameter");
              local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
              local xSpeed, ySpeed = Utils.getVectorFromString(getXMLString(xmlFile, key.."#speed"));
              if node ~= nil then
                  table.insert(self.tipScrollers, {node=node, shaderParameter=shaderParameter, xSpeed=xSpeed, ySpeed=ySpeed});
                  setShaderParameter(node, shaderParameter, 0, 0, 0, 0, false);
              end;
              i = i + 1;
          end;
      end;

      local start = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundDropArea#startIndex"));
      local width = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundDropArea#widthIndex"));
      local height = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundDropArea#heightIndex"));
      if start ~= nil and width ~= nil and height ~= nil then
          local area = {};
          area.start = start;
          area.width = width;
          area.height = height;
          self.groundDropArea = area;
      end;

      self.groundAmountAccumulation = 0;

      self.isSelectable = true;

      self.allowTipDischarge = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.allowTipDischarge#value"), true);
 end;

 function CattleTrailer:delete()
       if self.isClient then
          for _, tipAnimations in pairs(self.tipAnimations) do
               for _, particleSystem in pairs(tipAnimations.dischargeParticleSystems) do
                   Utils.deleteParticleSystem(particleSystem);
               end
           end
       end

       if self.hydraulicSound ~= nil then
           delete(self.hydraulicSound);
       end;
       if self.fillSound ~= nil then
           delete(self.fillSound);
       end;

 end;

function CattleTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

 function CattleTrailer:keyEvent(unicode, sym, modifier, isDown)
 end;

function CattleTrailer:readStream(streamId, connection)
      if connection:getIsServer() then
          local tipState = streamReadUIntN(streamId, 2);
          if tipState ~= CattleTrailer.TIPSTATE_CLOSED then
              local tipReferencePointIndex = streamReadUIntN(streamId, 4);
              local animTime = streamReadFloat32(streamId);

             if self.currentTipReferencePointIndex ~= nil and self.currentTipReferencePointIndex ~= tipReferencePointIndex then
                  self:disableCurrentTipAnimation(0);
              end

              if tipState == CattleTrailer.TIPSTATE_CLOSING then
                  self.currentTipReferencePointIndex = tipReferencePointIndex;
                  self:onEndTip(true);
              else
                  self:onStartTip(nil, tipReferencePointIndex, true);
              end;
             self:setCurrentTipAnimationTime(animTime);
          else
              self:disableCurrentTipAnimation(0);
          end;
          self.tipState = tipState;
      end;
end;

function CattleTrailer:writeStream(streamId, connection)
       if not connection:getIsServer() then
           assert(self.tipState >= 0 and self.tipState <= 3);
           streamWriteUIntN(streamId, self.tipState, 2);
           if self.tipState ~= CattleTrailer.TIPSTATE_CLOSED then
               local animTime = self:getCurrentTipAnimationTime();
               streamWriteFloat32(streamId, animTime);

               local tipReferencePointIndex = Utils.getNoNil(self.currentTipReferencePointIndex, 1);
               assert(tipReferencePointIndex <= 15);
               streamWriteUIntN(streamId, tipReferencePointIndex, 4);
           end;
       end;
end;

function CattleTrailer:update(dt)
      if self:getIsActiveForInput() then
          if self ~= g_currentMission.trailerInTipRange and self:getCanTipToGround() then

		   if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
                  self:toggleTipState(nil);
             end;
          end;
			
      end;
end;

function CattleTrailer:updateTick(dt)

     if self.tipState == CattleTrailer.TIPSTATE_OPENING or self.tipState == CattleTrailer.TIPSTATE_OPEN then

          if self.isServer then
              self:updateTipping(dt);
          end;

          if self.fillLevel <= 0 then
              self:onEndTip(true);
          end;

         if self.tipState == CattleTrailer.TIPSTATE_OPENING then
             if self:getCurrentTipAnimationTime() >= self:getCurrentTipAnimationDuration() then
                  self.tipState = CattleTrailer.TIPSTATE_OPEN;

                  if self.hydraulicSoundEnabled then
                      stopSample(self.hydraulicSound);
                      self.hydraulicSoundEnabled = false;
                  end;
              end;
          end;

          if self.isClient then
              if self.tipState == CattleTrailer.TIPSTATE_OPENING then
                  if not self.hydraulicSoundEnabled and self.hydraulicSound ~= nil and self:getIsActiveForSound() then
                     playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
                      self.hydraulicSoundEnabled = true;
                  end;
             end;

              -- check if we still are in opening/open state. Maybe we ended tipping before.
              if (self.tipState == CattleTrailer.TIPSTATE_OPENING or self.tipState == CattleTrailer.TIPSTATE_OPEN) and self.fillLevel > 0 then
                  if not self.fillSoundEnabled and self.fillSound ~= nil and self:getIsActiveForSound() then
                      playSample(self.fillSound, 0, self.fillSoundVolume, 0);
                      self.fillSoundEnabled = true;
                  end;
              else
                  if self.fillSoundEnabled then
                      stopSample(self.fillSound);
                      self.fillSoundEnabled = false;
                  end;
              end;
          end;

      elseif self.tipState == CattleTrailer.TIPSTATE_CLOSING then

          if self.isClient then
              if not self.hydraulicSoundEnabled and self.hydraulicSound ~= nil and self:getIsActiveForSound() then
                  playSample(self.hydraulicSound, 0, self.hydraulicSoundVolume, 0);
                   self.hydraulicSoundEnabled = true;
              end;
          end;

          if self:getCurrentTipAnimationTime() <= 0.0 then
             if self.hydraulicSoundEnabled then
                  stopSample(self.hydraulicSound);
                  self.hydraulicSoundEnabled = false;
              end;
              self:disableCurrentTipAnimation();
              self.tipState = CattleTrailer.TIPSTATE_CLOSED;
              for _, scroller in pairs(self.tipScrollers) do
                  setShaderParameter(scroller.node, scroller.shaderParameter, 0, 0, 0, 0, false);
              end;
          end;
      end;

      if self.isClient then
          if self.currentTipReferencePointIndex ~= nil then
              local tipAnimation = self.tipAnimations[self.currentTipReferencePointIndex];
              if tipAnimation ~= nil then
                  if (self.tipState == CattleTrailer.TIPSTATE_OPENING or self.tipState == CattleTrailer.TIPSTATE_OPEN) and self.fillLevel > 0 and self:getCurrentTipAnimationTime() >= tipAnimation.dischargeStartTime then
                      Utils.setEmittingState(tipAnimation.dischargeParticleSystems[self.currentFillType], true);
                  else
                      Utils.setEmittingState(tipAnimation.dischargeParticleSystems[self.currentFillType], false);
                  end;
              end
          end

          if self.tipState ~= CattleTrailer.TIPSTATE_CLOSED then
              for _, node in pairs(self.tipRotationNodes) do
                  rotate(node.node, -dt*node.rotSpeed, 0, 0);
             end;
          end
     end;
end;

function CattleTrailer:updateTipping(dt)
      if not self.isServer then
          return;
      end;
      if self:getCanTip() then
          local fillType = self.currentFillType;

          local fillDelta = -self.fillLevel;
          if self.currentTipReferencePointIndex ~= nil then
              local animation = self.tipAnimations[self.currentTipReferencePointIndex];
              if animation ~= nil and animation.dischargeEndTime > animation.dischargeStartTime then
                  if self:getCurrentTipAnimationTime() >= animation.dischargeStartTime then
                     local m = self.capacity/((animation.dischargeEndTime-animation.dischargeStartTime)/animation.animationOpenSpeedScale);
                      fillDelta = -m * dt;
                  else
                      fillDelta = 0;
                  end
              end
          end

          if fillDelta < 0 then
              local curFill = self.fillLevel;
             self:setFillLevel(self.fillLevel + fillDelta, fillType);
              local fillDelta = self.fillLevel - curFill;
              self.lastFillDelta = fillDelta;

              if self.currentTipTrigger ~= nil then
                  if self.currentTipTrigger.updateTrailerTipping ~= nil then
                      self.currentTipTrigger:updateTrailerTipping(self, fillDelta*self.fillLevelToTippedFillLevel, fillType);
                  end
              elseif self:getCanTipToGround() then
                  if fillDelta < 0 then
                      local x, _,z = getWorldTranslation(self.groundDropArea.start);
                      local x1,_,z1 = getWorldTranslation(self.groundDropArea.width);
                      local x2,_,z2 = getWorldTranslation(self.groundDropArea.height);

                      local area = {x,z,x1,z1,x2,z2, -fillDelta*self.fillLevelToTippedFillLevel};
                      local area, bitType, valueAccumulation = CTrailerTipAreaEvent.runLocally(area, fillType, self.groundAmountAccumulation)
                      if area ~= nil then
                          g_server:broadcastEvent(CTrailerTipAreaEvent:new(area, bitType, fillType));
                      end;
                     if valueAccumulation ~= nil then
                          self.groundAmountAccumulation = valueAccumulation;
                      end;
                  end;
              end;
          end
      else
          self:onEndTip();
      end;
end;

function CattleTrailer:draw()
      if self.isClient then
          if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
             g_currentMission:setFillTypeOverlayFillType(self.currentFillType);
          end;

         if self:getIsActiveForInput(true) then

              if self ~= g_currentMission.trailerInTipRange and self:getCanTipToGround() then
				g_currentMission:addHelpButtonText(g_i18n:getText("Dump"), InputBinding.IMPLEMENT_EXTRA);
                  --g_currentMission:enableHudIcon("tip");
              end;
          end
      end;
end;

function CattleTrailer:toggleTipState(tipTrigger, tipReferencePointIndex)

      if self.tipState == CattleTrailer.TIPSTATE_CLOSED or self.tipState == CattleTrailer.TIPSTATE_CLOSING then
		 self:onStartTip(tipTrigger, tipReferencePointIndex);
      else
          self:onEndTip();
      end;
end;


function CattleTrailer:onStartTip(tipTrigger, tipReferencePointIndex, noEventSend)
			-- selects the tipReference for the tipAnimation.
			if self.currentFillType == Fillable.FILLTYPE_COW then
				--print ("cows loaded", tipReferencePointIndex);
				tipReferencePointIndex = 1;
			elseif self.currentFillType == Fillable.FILLTYPE_SHEEP then
				--print ("sheeps loaded", tipReferencePointIndex, self.capacity);
				tipReferencePointIndex = 2;
			elseif self.currentFillType == Fillable.FILLTYPE_CHICKEN then
				--print ("chicken loaded", tipReferencePointIndex);
				tipReferencePointIndex = 3;
			elseif self.currentFillType == Fillable.FILLTYPE_PIG then
				--print ("pigs loaded", tipReferencePointIndex);
				tipReferencePointIndex = 4;
				else
				tipReferencePointIndex = 5;
			end;


	 -- we can not start tipping while we are tipping with another animation
      if self.isServer then
          if self.currentTipReferencePointIndex ~= nil and self.currentTipReferencePointIndex ~= tipReferencePointIndex then
              return;
         end
      end

     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(CTrailerToggleTipEvent:new(self, true, tipTrigger, tipReferencePointIndex), nil, nil, self);
         else
              g_client:getServerConnection():sendEvent(CTrailerToggleTipEvent:new(self, true, tipTrigger, tipReferencePointIndex));
         end;
	end;

      if self.isServer then
          self.currentTipTrigger = tipTrigger;
          self.groundAmountAccumulation = 0;
      end
      self:enableTipAnimation(tipReferencePointIndex, 1);
      self.currentTipReferencePointIndex = tipReferencePointIndex;
      self.tipState = CattleTrailer.TIPSTATE_OPENING;

      for _, scroller in pairs(self.tipScrollers) do
          setShaderParameter(scroller.node, scroller.shaderParameter, scroller.xSpeed, scroller.ySpeed, 0, 0, false);
      end;
end;

function CattleTrailer:onEndTip(noEventSend)

      if noEventSend == nil or noEventSend == false then
           if g_server ~= nil then
              g_server:broadcastEvent(CTrailerToggleTipEvent:new(self, false), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(CTrailerToggleTipEvent:new(self, false));
          end;
     end;
       if self.currentTipReferencePointIndex ~= nil then
          self:enableTipAnimation(self.currentTipReferencePointIndex, -1);
      end

       if self.isServer then
          self.currentTipTrigger = nil;
      end

       if self.fillSoundEnabled then
           stopSample(self.fillSound);
           self.fillSoundEnabled = false;
       end;

      self.tipState = CattleTrailer.TIPSTATE_CLOSING;
end;

function CattleTrailer:getCurrentFruitType()
      local fruitType = FruitUtil.fillTypeToFruitType[self.currentFillType];
      if fruitType == nil then
          fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
      end;
	  
      return fruitType;
	  
end;

function CattleTrailer:setFillLevel(fillLevel, fillType, capacity, force)
-- change self.capacity = 5; to self.capacity = your number; to have it load more or less.
			-- Animals
			
			
			if self.currentFillType == Fillable.FILLTYPE_COW then
				self.capacity = 5;
			elseif self.currentFillType == Fillable.FILLTYPE_SHEEP then
				self.capacity = 10;
			elseif self.currentFillType == Fillable.FILLTYPE_CHICKEN then
				self.capacity = 50;
				self.grainTankCapacity =50;
			elseif self.currentFillType == Fillable.FILLTYPE_PIG then
				self.capacity = 10;
			
			else 
			-- Fruits, not AnimalTypes
				self.capacity = 5000;
			end;
			local capacity = self.capacity;
			
			
		
      if self.isClient then
         -- disable particle system if we switch the type or if the trailer is empty
         if (self.currentFillType ~= fillType or fillLevel <= 0) and self.currentTipReferencePointIndex ~= nil then
             local tipAnimation = self.tipAnimations[self.currentTipReferencePointIndex];
              if tipAnimation ~= nil then
                  Utils.setEmittingState(tipAnimation.dischargeParticleSystems[self.currentFillType], false);
             end
          end
      end 
--print (tostring("capacity" ..self.capacity .."/" ..capacity .."/" ..fillLevel));
end;

function CattleTrailer:onAttach(attacherVehicle)
end;

function CattleTrailer:onDetach()
      if self.deactivateOnDetach then
          CattleTrailer.onDeactivate(self);
      else
          CattleTrailer.onDeactivateSounds(self);
      end;
end;

function CattleTrailer:onLeave()
      if self.deactivateOnLeave then
          CattleTrailer.onDeactivate(self);
      else
          CattleTrailer.onDeactivateSounds(self);
      end;
end;

function CattleTrailer:onDeactivate()
      CattleTrailer.onDeactivateSounds(self);
end;

function CattleTrailer:onDeactivateSounds()
     if self.fillSoundEnabled then
         stopSample(self.fillSound);
         self.fillSoundEnabled = false;
      end;
      if self.hydraulicSoundEnabled then
         stopSample(self.hydraulicSound);
         self.hydraulicSoundEnabled = false;
    end;
end;

function CattleTrailer:getCanTip()
      if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
          if self.currentTipTrigger ~= nil then
              return g_currentMission:getIsTrailerInTipRange(self, self.currentTipTrigger, self.currentTipReferencePointIndex);
          else
              return self:getCanTipToGround();
          end
      end
      return false;
end

function CattleTrailer:getCanTipToGround()
     return g_currentMission.groundValueIds[self.currentFillType] ~= nil and self.groundDropArea ~= nil;
end;

function CattleTrailer:enableTipAnimation(tipReferencePointIndex, direction, animTime)
       if self.currentTipReferencePointIndex ~= tipReferencePointIndex then
          self:disableCurrentTipAnimation(0);
      end

      self.currentTipReferencePointIndex = tipReferencePointIndex;

      local animation = self.tipAnimations[tipReferencePointIndex];

      if animation ~= nil then
         local speedScale = animation.animationOpenSpeedScale;
          if direction < 0 then
              speedScale = animation.animationCloseSpeedScale;
          end
         if animation.animationName ~= nil then
              self:playAnimation(animation.animationName, speedScale, self:getAnimationTime(animation.animationName), true);
               if animTime ~= nil then
                 self:setRealAnimationTime(animation.animationName, animTime);
               end
          elseif animation.animationCharSet ~= nil then
             enableAnimTrack(animation.animationCharSet, 0);
             setAnimTrackSpeedScale(animation.animationCharSet, 0, speedScale);
              if animTime ~= nil then
                  setAnimTrackTime(animation.animationCharSet, 0, animTime);
              else
                  if direction > 0 then
                     if getAnimTrackTime(animation.animationCharSet, 0) < 0 then
                           setAnimTrackTime(animation.animationCharSet, 0, 0);
                     end;
                 else
                      if getAnimTrackTime(animation.animationCharSet, 0) > animation.animationDuration then
                           setAnimTrackTime(animation.animationCharSet, 0, animation.animationDuration);
                     end;
                 end
              end
          end
      end
end

function CattleTrailer:disableCurrentTipAnimation(animTime)
     if self.currentTipReferencePointIndex ~= nil then
         local animation = self.tipAnimations[self.currentTipReferencePointIndex];
         if animation ~= nil then
             Utils.setEmittingState(animation.dischargeParticleSystems[self.currentFillType], false);

               if animation.animationName ~= nil then
                  if animTime ~= nil then
                     self:setRealAnimationTime(animation.animationName, math.min(animTime, animation.animationDuration));
                  end
                  self:stopAnimation(animation.animationName, true);
              elseif animation.animationCharSet ~= nil then
                   if animTime ~= nil then
                     enableAnimTrack(animation.animationCharSet, 0);
                      setAnimTrackTime(animation.animationCharSet, 0, animTime, true);
                end
                  disableAnimTrack(animation.animationCharSet, 0);
             end
          end
         self.currentTipReferencePointIndex = nil;
     end
end

function CattleTrailer:setCurrentTipAnimationTime(animTime)
      if self.currentTipReferencePointIndex ~= nil then
          local animation = self.tipAnimations[self.currentTipReferencePointIndex];
       if animation ~= nil then
            if animation.animationName ~= nil then
                  self:setRealAnimationTime(animation.animationName, math.min(animTime, animation.animationDuration));
             elseif animation.animationCharSet ~= nil then
               setAnimTrackTime(animation.animationCharSet, 0, animTime);
            end
         end
     end
end

function CattleTrailer:getCurrentTipAnimationTime()
      if self.currentTipReferencePointIndex ~= nil then
         local animation = self.tipAnimations[self.currentTipReferencePointIndex];
         if animation ~= nil then
             if animation.animationName ~= nil then
                 return self:getRealAnimationTime(animation.animationName);
             elseif animation.animationCharSet ~= nil then
                 return getAnimTrackTime(animation.animationCharSet, 0);
             end
         end
     end
    return 0;
end

function CattleTrailer:getCurrentTipAnimationDuration()
      if self.currentTipReferencePointIndex ~= nil then
        local animation = self.tipAnimations[self.currentTipReferencePointIndex];
         if animation ~= nil then
             return animation.animationDuration;
        end
    end
   return 0;
end
