--
-- Specialization CattleTrailerToggleTipEvent
-- This script select the TipAnimation/TipReferencePoint based on the fruitType/fillType
--
--
-- @author:		Jengske_BE  (www.international-modding.eu)
-- @email:		ponystal-peeters@telenet.be
-- @version:	v1.0
-- @date:		22/01/14
-- @history:	v1.0 - inital implementation
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
 
CTrailerToggleTipEvent = {};
CTrailerToggleTipEvent_mt = Class(CTrailerToggleTipEvent, Event);
    
--InitStaticEventClass
InitEventClass(CTrailerToggleTipEvent, "CTrailerToggleTipEvent", EventIds.EVENT_CTRAILER_TOGGLE_TIP);
    
function CTrailerToggleTipEvent:emptyNew()
        local self = Event:new(CTrailerToggleTipEvent_mt);
     return self;
 end;
  
function CTrailerToggleTipEvent:new(object, isStart, tipTrigger, tipReferencePointIndex)
       local self = CTrailerToggleTipEvent:emptyNew()
       self.isStart = isStart;
       self.tipTrigger = tipTrigger;
       self.tipReferencePointIndex = Utils.getNoNil(tipReferencePointIndex, 1);
      assert(self.tipReferencePointIndex <= 15);
       self.object = object;
      return self;
 end;
  
function CTrailerToggleTipEvent:readStream(streamId, connection)
        local id = streamReadInt32(streamId);
        self.isStart = streamReadBool(streamId);
        if self.isStart then
           local triggerId = streamReadInt32(streamId);
           if triggerId ~= 0 then
               self.tipTrigger = networkGetObject(triggerId);
           end;
          self.tipReferencePointIndex = streamReadUIntN(streamId, 4);
       end;
      self.object = networkGetObject(id);
       self:run(connection);
end;
    
function CTrailerToggleTipEvent:writeStream(streamId, connection)
        streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.isStart);
        if self.isStart then
            local triggerId = 0;
            if self.tipTrigger ~= nil then
               triggerId = networkGetObjectId(self.tipTrigger);
           end;
            streamWriteInt32(streamId, triggerId);
            streamWriteUIntN(streamId, self.tipReferencePointIndex, 4);
     end;
 end;
    
function CTrailerToggleTipEvent:run(connection)
        if not connection:getIsServer() then
            g_server:broadcastEvent(self, false, connection, self.object);
        end;
    
        if self.isStart then
           self.object:onStartTip(self.tipTrigger, self.tipReferencePointIndex, true);
        else
            self.object:onEndTip(true);
       end;
end;