--
-- exhaustCap specialization v1.0
--
-- author: Saty / forum.lsczech.cz
-- date: 10.03.2013
--
-- EN -- Specialization for exhaust cap animation
-- CZ -- Specializace pro animaci klapky vyfuku
--

exhaustCap = {};

function exhaustCap.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function exhaustCap:load(xmlFile)
	local capNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.exhaustCap#index"));
    if capNode ~= nil then
        self.cap = {};
        self.cap.node = capNode;
        
        self.cap.minRot = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.exhaustCap#minRotX")), 0);
        self.cap.maxRot = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.exhaustCap#maxRotX")), 0);

        self.cap.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.exhaustCap#rotTime"), 2)*1000;
    end;
end;

function exhaustCap:delete()
end;

function exhaustCap:mouseEvent(posX, posY, isDown, isUp, button)
end;

function exhaustCap:keyEvent(unicode, sym, modifier, isDown)
end;

function exhaustCap:update(dt)
	if self.isMotorStarted and self.cap ~= nil then
		local x, y, z = getRotation(self.cap.node);
    	local rot = {x,y,z};
		local capAngle = self.cap.minRot + ((math.random(0,150) + (self.motor.lastMotorRpm * 1.8) - 500) * 0.001);
		if capAngle < self.cap.minRot then
			capAngle = self.cap.minRot;
		elseif capAngle > self.cap.maxRot then
			capAngle = self.cap.maxRot;
		end;
    	local newRot = Utils.getMovedLimitedValues(rot, {180,y,z}, {capAngle,y,z}, 3, 60000, dt, true);
    	setRotation(self.cap.node, unpack(newRot));
	else
		local x, y, z = getRotation(self.cap.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, {self.cap.minRot,y,z}, {self.cap.maxRot,y,z}, 3, self.cap.rotTime, dt, false);
		setRotation(self.cap.node, unpack(newRot));
	end;
end;

function exhaustCap:draw()
end;