--
--
--
-- Register fruits for transporting and tipping particle
--
function RegisterFruits()
	local fruitList = {};

    table.insert(fruitList, {type="none", fruitName="fertilizer",	needsSeeding=false, allowsSeeding=false, hasStraw=false, minHarvestingGrowthState=99, pricePerLiter=1.00, literPerQm=9.9, seedUsagePerQm=9.99, seedPricePerLiter=9.9} );
	table.insert(fruitList, {type="none", fruitName="tomato",		needsSeeding=false, allowsSeeding=false, hasStraw=false, minHarvestingGrowthState=99, pricePerLiter=1.00, literPerQm=9.9, seedUsagePerQm=9.99, seedPricePerLiter=9.9} );
	table.insert(fruitList, {type="none", fruitName="carrot",		needsSeeding=false, allowsSeeding=false, hasStraw=false, minHarvestingGrowthState=99, pricePerLiter=1.00, literPerQm=9.9, seedUsagePerQm=9.99, seedPricePerLiter=9.9} );
	table.insert(fruitList, {type="none", fruitName="onion",		needsSeeding=false, allowsSeeding=false, hasStraw=false, minHarvestingGrowthState=99, pricePerLiter=1.00, literPerQm=9.9, seedUsagePerQm=9.99, seedPricePerLiter=9.9} );
	table.insert(fruitList, {type="none", fruitName="sand",			needsSeeding=false, allowsSeeding=false, hasStraw=false, minHarvestingGrowthState=99, pricePerLiter=1.00, literPerQm=9.9, seedUsagePerQm=9.99, seedPricePerLiter=9.9} );
	table.insert(fruitList, {type="none", fruitName="gravel",		needsSeeding=false, allowsSeeding=false, hasStraw=false, minHarvestingGrowthState=99, pricePerLiter=1.00, literPerQm=9.9, seedUsagePerQm=9.99, seedPricePerLiter=9.9} );

    --
    print(string.format("Registering %d extra fruits...", table.getn(fruitList)));
    for i=1, table.getn(fruitList) do
        local filename = "Extras/MapFruits/images/".. fruitList[i].fruitName .."Hud.png";
        local hudFile = Utils.getFilename(filename, g_currentModDirectory);
        FruitUtil.registerFruitType(
             fruitList[i].fruitName                 -- string fruitName
            ,fruitList[i].needsSeeding              -- bool needsSeeding
            ,fruitList[i].allowsSeeding             -- bool allowsSeeding
            ,fruitList[i].hasStraw                  -- bool hasStraw
            ,fruitList[i].minHarvestingGrowthState  -- int minHarvestingGrowthState
            ,fruitList[i].pricePerLiter             -- float pricePerLiter
            ,fruitList[i].literPerQm                -- float literPerQm
            ,fruitList[i].seedUsagePerQm            -- float seedUsagePerQm
            ,fruitList[i].seedPricePerLiter         -- float seedPricePerLiter
            ,hudFile                                -- file hudFruitOverlayFilename
        );
    end;
end;
RegisterFruits();
