--
-- gaz53
--
-- M@D Author  StarT,     Edit: Silak_68 (04/08/2013)
-- M@D date  16.12.2011
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --


gaz53 = {}

function gaz53.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return true ;
end;

function gaz53:load(xmlFile)

      self.cabinlight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cabinlight#index"));
      self.cabinlightActive = false;

local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
	local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	local rotationPartNodekapot = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kapot#index"));
    if rotationPartNodekapot ~= nil then
        self.rotationPartkapot = {};
        self.rotationPartkapot.node = rotationPartNodekapot;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kapot#minRot"));
        self.rotationPartkapot.minRot = {};
        self.rotationPartkapot.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkapot.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkapot.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kapot#maxRot"));
        self.rotationPartkapot.maxRot = {};
        self.rotationPartkapot.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkapot.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkapot.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkapot.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kapot#rotTime"), 2)*1000;
        self.rotationPartkapot.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kapot#touchRotLimit"), 10));
    end;

--[[]]------------------------------------------------------------
self.crankshaftNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.crankshaft#index"));


local rotationPartNodeKmh1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;
	
	self.drivingParticles = {};
    if self.isClient then
        local i=0;
        while true do
            local key = string.format("vehicle.drivingParticles.drivingParticle(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
                break;
            end;
            local particle = {};
            particle.ps = {};
            Utils.loadParticleSystem(xmlFile, particle.ps, key, self.components, false, nil, self.baseDirectory);
            if table.getn(particle.ps) > 0 then
                particle.minSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minSpeed"), 2)/3600;
                particle.maxSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxSpeed"), 40)/3600;
                particle.minScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minScale"), 0.2);
                particle.maxScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxScale"), 1);
                particle.direction = Utils.getNoNil(getXMLFloat(xmlFile, key.."#direction"), 1);
				particle.wheel = getXMLInt(xmlFile, key .. "#wheel");
				particle.lastScale = 0;
                table.insert(self.drivingParticles, particle);
            end;

            i = i+1;
        end;
    end;
	self.drivingParticleThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingParticles#threshold"), 0.005);
	
	----< >-----	
    self.zerkala = {};
    self.zerkala[1] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zerkala.mirror1#index"));
    ----< >-----

end;
      
function gaz53:delete() 
    for _, particle in pairs(self.drivingParticles) do
        Utils.deleteParticleSystem(particle.ps);
    end;   
end;

function gaz53:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function gaz53:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_KP_0 then
	self.help = not self.help;
    end;

--[[Blinker start]]------------------------------------------------------------	
--[[Blinker Rechts]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_1 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Blinker Links]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_3 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
--[[Blinker ende]]------------------------------------------------------------
	 if isDown and sym == Input.KEY_KP_9 then 
	self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
	self.rotationMaxrightdoor1 = not self.rotationMaxrightdoor1;
    end;
	if isDown and sym == Input.KEY_KP_7 then 
	self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	self.rotationMaxleftDoor1 = not self.rotationMaxleftDoor1;
    end;
	if isDown and sym == Input.KEY_KP_8 then 
	self.rotationMaxkapot = not self.rotationMaxkapot;
	self.rotationMaxkapot1 = not self.rotationMaxkapot1;
    end;

    if isDown and sym == Input.KEY_KP_6 then
	    self.cabinlightActive = not self.cabinlightActive;
	end;
	if isDown and sym == Input.KEY_KP_2 then 
		self.drawMirror = not self.drawMirror;
		setVisibility(self.zerkala[1], self.drawMirror);
	end;

end;

function gaz53:update(dt)
--[[]]------------------------------------------------------------
local maxKmh = 50;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;
	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
	--[[Blinker start]]------------------------------------------------------------
	    if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
--[[Blinker ende]]------------------------------------------------------------
	if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
		if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;
		if self.rotationPartkapot ~= nil then
		   local x, y, z = getRotation(self.rotationPartkapot.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkapot.maxRot, self.rotationPartkapot.minRot, 3, self.rotationPartkapot.rotTime, dt, not self.rotationMaxkapot);
		   setRotation(self.rotationPartkapot.node, unpack(newRot));
        end;

if self.isEntered then
		setVisibility(self.cabinlight, self.cabinlightActive);
	end;
end;

function gaz53:draw()
if not self.help then
	setTextColor(1,1,1,1);
            renderText(0.76, 0.167, 0.0193, g_i18n:getText("InfoOn"));
        else
		  renderText();
        end;
        
        if self.help then
		renderText(0.76, 0.167, 0.0193, g_i18n:getText("InfoOff"));
		renderText(0.76, 0.60, 0.025, g_i18n:getText("Info_avto"));
        renderText(0.76, 0.58, 0.02, g_i18n:getText("Signal"));
        renderText(0.76, 0.56, 0.02, g_i18n:getText("Svet"));
        renderText(0.76, 0.54, 0.02, g_i18n:getText("Svet1"));		
		renderText(0.76, 0.52, 0.02, g_i18n:getText("Lev_povorot"));
		renderText(0.76, 0.50, 0.02, g_i18n:getText("Prav_povorot"));
		renderText(0.76, 0.48, 0.02, g_i18n:getText("Lev_dver"));
		renderText(0.76, 0.46, 0.02, g_i18n:getText("Prav_dver"));
		renderText(0.76, 0.44, 0.02, g_i18n:getText("Kapot"));
		renderText(0.76, 0.42, 0.02, g_i18n:getText("Zerkala"));
		end;

end;

function gaz53:updateTick(dt)	

	if self.isClient then	
		if self:getIsActive() then
			local isVisible = false;
			local camera = getCamera();
			if camera ~= 0 then
				local x,y,z = getWorldTranslation(camera);
				local x1,y1,z1 = getWorldTranslation(self.rootNode);
				local distance = Utils.vector3Length(x-x1,y-y1,z-z1);
				isVisible = (distance < 300);
			end;
			
            for k, particle in pairs(self.drivingParticles) do		
				local isActive = false;
				
				if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
					if particle.wheel ~= nil then
						local x,y,z = getWorldTranslation(self.wheels[particle.wheel].repr);--getWheelShapeContactPoint(self.wheels[particle.wheel].node, self.wheels[particle.wheel].wheelShape);
						y = y - self.wheels[particle.wheel].radius;
						
						if y ~= nil then
							local height = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x,y,z); 
							local hasGroundContact = math.abs(y - height) < self.drivingParticleThreshold;
							
							if self.lastSpeedReal > particle.minSpeed and (particle.direction == 0 or (particle.direction > 0) == (self.movingDirection > 0)) and hasGroundContact then								
								isActive = isVisible;
							end;
						end;
					end;
				end;
				Utils.setEmittingState(particle.ps, isActive);
            end;
		else
			for _, particle in pairs(self.drivingParticles) do
				Utils.setEmittingState(particle.ps, false);
			end;
        end;
    end;
end;

function gaz53:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
