--
-- fTr
--
-- M@D Author  StarT,     Edit: Silak_68 (04/08/2013)
-- M@D date  16.12.2011
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --


fTr = {}

function fTr.prerequisitesPresent(specializations)
	Vehicle.registerJointType("fuelTrailer");
    return true ;
end;

function fTr:load(xmlFile)

local rotationPartNodetrigW = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trigW#index"));
    if rotationPartNodetrigW ~= nil then
        self.rotationParttrigW = {};
        self.rotationParttrigW.node = rotationPartNodetrigW;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.trigW#minRot"));
        self.rotationParttrigW.minRot = {};
        self.rotationParttrigW.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttrigW.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttrigW.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.trigW#maxRot"));
        self.rotationParttrigW.maxRot = {};
        self.rotationParttrigW.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttrigW.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttrigW.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParttrigW.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.trigW#rotTime"), 2)*1000;
        self.rotationParttrigW.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.trigW#touchRotLimit"), 10));
    end;
	
	self.drivingParticleThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingParticles#threshold"), 0.005);
	local rotationPartNodetrigQ = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.trigQ#index"));
    if rotationPartNodetrigQ ~= nil then
        self.rotationParttrigQ = {};
        self.rotationParttrigQ.node = rotationPartNodetrigQ;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.trigQ#minRot"));
        self.rotationParttrigQ.minRot = {};
        self.rotationParttrigQ.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttrigQ.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttrigQ.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.trigQ#maxRot"));
        self.rotationParttrigQ.maxRot = {};
        self.rotationParttrigQ.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttrigQ.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttrigQ.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParttrigQ.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.trigQ#rotTime"), 2)*1000;
        self.rotationParttrigQ.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.trigQ#touchRotLimit"), 10));
    end;
	----< >-----	
    self.mirrors = {};
    self.mirrors[1] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.mirrors.mirror1#index"));
    ----< >-----
end;
      
function fTr:delete()    
end;

function fTr:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function fTr:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_KP_0 then
	self.help = not self.help;
    end;
    
	if isDown and sym == Input.KEY_KP_4 then 
	self.rotationMaxtrigQ = not self.rotationMaxtrigQ;
	self.rotationMaxtrigQ1 = not self.rotationMaxtrigQ1;
    end;
	 
	if isDown and sym == Input.KEY_KP_4 then 
	self.rotationMaxtrigW = not self.rotationMaxtrigW;
	self.rotationMaxtrigW1 = not self.rotationMaxtrigW1;
    end;
	
	if isDown and sym == Input.KEY_KP_4 then 
		self.drawMirror = not self.drawMirror;
		setVisibility(self.mirrors[1], self.drawMirror);
	end;
end;

function fTr:update(dt)

	    if self.rotationParttrigW ~= nil then
		   local x, y, z = getRotation(self.rotationParttrigW.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParttrigW.maxRot, self.rotationParttrigW.minRot, 3, self.rotationParttrigW.rotTime, dt, not self.rotationMaxtrigW);
		   setRotation(self.rotationParttrigW.node, unpack(newRot));
        end;
		
		if self.rotationParttrigQ ~= nil then
		   local x, y, z = getRotation(self.rotationParttrigQ.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParttrigQ.maxRot, self.rotationParttrigQ.minRot, 3, self.rotationParttrigQ.rotTime, dt, not self.rotationMaxtrigQ);
		   setRotation(self.rotationParttrigQ.node, unpack(newRot));
        end;
end;

function fTr:draw()
        
		if self.help then
		renderText(0.76, 0.40, 0.02, g_i18n:getText("trigQ"));
		end;
		if self.help then
		renderText(0.76, 0.38, 0.02, g_i18n:getText("Flasher"));
		end;
end;

function fTr:updateTick(dt)	

end;

function fTr:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
