SetRangeEvent = {};
SetRangeEvent_mt = Class(SetRangeEvent, Event);

InitEventClass(SetRangeEvent, "SetRangeEvent");

function SetRangeEvent:emptyNew()
    local self = Event:new(SetRangeEvent_mt);
    self.className="SetRangeEvent";
    return self;
end;

function SetRangeEvent:new(vehicle, direction)
    local self = SetRangeEvent:emptyNew()
    self.vehicle = vehicle;
	self.direction = direction;
    return self;
end;

function SetRangeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.direction = streamWriteInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRangeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.direction);
end;

function SetRangeEvent:run(connection)   
	self.vehicle:setRange(self.direction, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRangeEvent:new(vehicle, self.direction), nil, connection, self.vehicle);
    end;
end;

function SetRangeEvent.sendEvent(vehicle, direction, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRangeEvent:new(vehicle, direction), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRangeEvent:new(vehicle, direction));
		end;
	end;
end;