--
-- Twinwheel
--
-- @author  Geri-G
-- @date  09/08/09
--
-- Copyright (C) Geri-G--


wheehl = {};

function wheehl.prerequisitesPresent(specializations)
    Vehicle.registerJointType("Quicke");
	return true;
end;

function wheehl:load(xmlFile)
	local NumVisWheelsParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.WheelsVis#count"), 0);
    self.VisWheels = {};
    for i=1, NumVisWheelsParts do
      local partnamei = string.format("vehicle.WheelsVis.Wheel" .. "%d", i);
      self.VisWheels[i] = {};
      self.VisWheels[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      self.VisWheels[i].index2 = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index2"));
      self.VisWheels[i].Change = Utils.getNoNil(getXMLString(xmlFile, partnamei .. "#Change"),"false");
	  setVisibility(self.VisWheels[i].index, true);
	  setVisibility(self.VisWheels[i].index2, false);
	end;
	self.WheelsVis = false

end;

function wheehl:delete()
end;

function wheehl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheehl:keyEvent(unicode, sym, modifier, isDown)
end;

function wheehl:update(dt)

    if self:getIsActiveForInput() then   
		if InputBinding.hasEvent(InputBinding.SwitchWheel) then
            self.WheelsVis = not self.WheelsVis;
        end;
	end;

		for i=1, table.getn(self.VisWheels) do
			setVisibility(self.VisWheels[i].index2, self.WheelsVis);
			if self.VisWheels[i].Change == "true" then
				setVisibility(self.VisWheels[i].index, not self.WheelsVis);
			else
				setVisibility(self.VisWheels[i].index, true);
			end;
		end;

		
end;
function wheehl:draw()
	if self.attacherVehicle then
		g_currentMission:addHelpButtonText(g_i18n:getText("SwitchWheel"), InputBinding.SwitchWheel);
	end;
end;
