--
-- Schwenkverteiler
-- Specialization for Schwenkverteiler

Schwenkverteiler = {};

function Schwenkverteiler.prerequisitesPresent(specializations)
    return true;
end;


function Schwenkverteiler:load(xmlFile)

	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Schwenkverteiler#rootNode"));

	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.Schwenkverteiler#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Schwenkverteiler#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
	self.allumer = false;
	self.animationSpeed = 0;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Schwenkverteiler#offsetTime"), 3) * 1000;
end;

function Schwenkverteiler:delete()
end;

function Schwenkverteiler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Schwenkverteiler:keyEvent(unicode, sym, modifier, isDown)
end;

function Schwenkverteiler:readStream(streamId, connection)
end;

function Schwenkverteiler:writeStream(streamId, connection)
end;

function Schwenkverteiler:readUpdateStream(streamId, timestamp, connection)
end;

function Schwenkverteiler:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Schwenkverteiler:update(dt)
end;

function Schwenkverteiler:updateTick(dt)
	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isTurnedOn and not self.attacherVehicle.wasToFast then
			self.allumer = true;
		else
			self.allumer = false;
		end;
	else
		setAnimTrackTime(self.animation.animCharSet, 0, 0, true);
	end;
	
	if self:getIsActive() then
		if self.allumer then	
            if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;
		else
			if self.animationEnabled then
				if self.animationSpeed < 0.01 then
					disableAnimTrack(self.animation.animCharSet, 0);
					self.animationEnabled = false;
				else
					enableAnimTrack(self.animation.animCharSet, 0);
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
			end;
        end;
	end;
end;

function Schwenkverteiler:draw()
end;

function Schwenkverteiler:onDeactivate()
end;

function Schwenkverteiler:onLeave()
end;

function Schwenkverteiler:onDetach()
end;
function Schwenkverteiler:onAttach()
end;