--
-- Fuchs Guellefass
-- Class for the Fuchs Guellefass
--
-- @author  Stefan Maurus - www.stefanmaurus.de
-- @date  20.08.2012
--
Vehicle.registerJointType("distributor");

FuchsGuellefass = {};
  
function FuchsGuellefass.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function FuchsGuellefass:load(xmlFile)
	self.setdeckelAnimationisPlaying = SpecializationUtil.callSpecializationsFunction("setdeckelAnimationisPlaying"); 

	-- Fuellstandsanzeiger 
	self.Zeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Zeiger#index"));	
	self.ZeigerMin =  Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zeiger#rotationMax"));	
	self.ZeigerMax =  Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zeiger#rotationMin"));	
	self.ZeigerAchse = getXMLString(xmlFile, "vehicle.Zeiger#rotationAchse");
	self.XAchse = "x";
	self.YAchse = "y";
	self.ZAchse = "z";
	self.PositiveZahl = false;
	self.NegativeZahl = false;
	self.ZeigerRotationNew = 0;

	-- Sounds
	self.ManurefillSoundIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ManurefillSound#index"));	
  	local ManurefillSound = getXMLString(xmlFile, "vehicle.ManurefillSound#file");
    if ManurefillSound ~= nil and ManurefillSound ~= "" then
		ManurefillSound = Utils.getFilename(ManurefillSound, self.baseDirectory);
		self.ManurefillSound = createAudioSource("ManurefillSound", ManurefillSound, 30, 25, 0.5, 0);
		link(self.ManurefillSoundIndex, self.ManurefillSound);
		setVisibility(self.ManurefillSound, false);
    end;
	
  	local ManurefillSoundMax = getXMLString(xmlFile, "vehicle.ManurefillSound#file");
    if ManurefillSoundMax ~= nil and ManurefillSoundMax ~= "" then
		ManurefillSoundMax = Utils.getFilename(ManurefillSoundMax, self.baseDirectory);
		self.ManurefillSoundMax = createAudioSource("ManurefillSoundMax", ManurefillSoundMax, 30, 25, 1, 0);
		link(self.ManurefillSoundIndex, self.ManurefillSoundMax);
		setVisibility(self.ManurefillSoundMax, false);
    end;		
	
	--Animations
    local deckelAnimation = {};
    deckelAnimation.name = getXMLString(xmlFile, "vehicle.deckelAnimation#name");
    deckelAnimation.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.deckelAnimation#openSpeedScale"), 1);
    deckelAnimation.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.deckelAnimation#closeSpeedScale"), -deckelAnimation.openSpeedScale);
    if deckelAnimation.name ~= nil then
        self.deckelAnimation = deckelAnimation;
    end;	
	self.deckelAnimationisPlaying = false;
	
	self.isFuchsFass = true;
	
	--Zapfwelle
	self.powershaftIsOn = false;
	self.powershaftWarningTime = 0;
    local powershaftAnimation = {};
    powershaftAnimation.name = getXMLString(xmlFile, "vehicle.powershaftAnimation#name");
    powershaftAnimation.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.powershaftAnimation#openSpeedScale"), 1);
    powershaftAnimation.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.powershaftAnimation#closeSpeedScale"), -powershaftAnimation.openSpeedScale);
    if powershaftAnimation.name ~= nil then
        self.powershaftAnimation = powershaftAnimation;
    end;	
	
	--Plane
	self.ManurePlane = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ManurePlane#index"));	
end;

function FuchsGuellefass:delete()
	setVisibility(self.ManurefillSound, false);
	setVisibility(self.ManurefillSoundMax, false);		
end;

function FuchsGuellefass:readStream(streamId, connection)
	self:setdeckelAnimationisPlaying(streamReadBool(streamId), true);	
end;

function FuchsGuellefass:writeStream(streamId, connection) 
	streamWriteBool(streamId, self.deckelAnimationisPlaying);
end;

function FuchsGuellefass:setdeckelAnimationisPlaying(bool, noEventSend)
	self.deckelAnimationisPlaying = bool;
	SetdeckelAnimationisPlayingEvent.sendEvent(self, bool, noEventSend);
end;

function FuchsGuellefass:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function FuchsGuellefass:keyEvent(unicode, sym, modifier, isDown)
end;
 
function FuchsGuellefass:update(dt)
	local rx, ry, rz = getRotation(self.Zeiger)
	local unterschiedMinMax = self.ZeigerMax - self.ZeigerMin; 
	if unterschiedMinMax > 0 then
		self.PositiveZahl = true;
		self.NegativeZahl = false;		
	else
		self.NegativeZahl = true;
		self.PositiveZahl = false;
	end;	
	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelPerCent = math.floor(fillLevelNew)
	local RotationStep = unterschiedMinMax / 100; 
	local ZeigerRotation = fillLevelPerCent * RotationStep; 
	local ZeigerRotationRad = math.rad(ZeigerRotation); 
	if self.PositiveZahl == true and self.NegativeZahl == false then
		self.ZeigerRotationNew = ZeigerRotationRad * -1;
	elseif self.PositiveZahl == false and self.NegativeZahl == true then
		self.ZeigerRotationNew = ZeigerRotationRad * 1;	
	end;
	if self.ZeigerAchse == self.XAchse then
		setRotation(self.Zeiger, self.ZeigerRotationNew, ry, rz)
	elseif self.ZeigerAchse == self.YAchse then
		setRotation(self.Zeiger, rx, self.ZeigerRotationNew, rz)	
	elseif self.ZeigerAchse == self.ZAchse then
		setRotation(self.Zeiger, rx, ry, self.ZeigerRotationNew)	
	end;
	
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.OpenCloseDeckel) then
			self:setdeckelAnimationisPlaying(not self.deckelAnimationisPlaying);	
		end;	
	end;	
end;

function FuchsGuellefass:updateTick(dt)
	
	if self.deckelAnimationisPlaying then
		self:playAnimation(self.deckelAnimation.name, self.deckelAnimation.openSpeedScale, self:getAnimationTime(self.deckelAnimation.name), true);
	else
		self:playAnimation(self.deckelAnimation.name, self.deckelAnimation.closeSpeedScale, self:getAnimationTime(self.deckelAnimation.name), true);	
	end;
	
	if self.isSprayerFilling or self.isTurnedOn then
		local animationTime = self:getAnimationTime(self.powershaftAnimation.name)
		if animationTime == 0 then
			self:playAnimation(self.powershaftAnimation.name, self.powershaftAnimation.openSpeedScale, self:getAnimationTime(self.powershaftAnimation.name), true);
		elseif animationTime == 1 then
			self:playAnimation(self.powershaftAnimation.name, self.powershaftAnimation.closeSpeedScale, self:getAnimationTime(self.powershaftAnimation.name), true);
		end;		
	end;

	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelPerCent = math.floor(fillLevelNew)	
	if fillLevelPerCent > 99 then
		setVisibility(self.ManurePlane, true);	
	else
		setVisibility(self.ManurePlane, false);	
	end;
	
	if self.isSprayerFilling then
		if fillLevelPerCent < 97 then
			setVisibility(self.ManurefillSound, true);
			setVisibility(self.ManurefillSoundMax, false);		
		elseif fillLevelPerCent > 97 then
			setVisibility(self.ManurefillSound, true);
			setVisibility(self.ManurefillSoundMax, true);	
		elseif fillLevelPerCent > 98 then
			setVisibility(self.ManurefillSound, false);
			setVisibility(self.ManurefillSoundMax, true);	
		end;
	else
		setVisibility(self.ManurefillSound, false);
		setVisibility(self.ManurefillSoundMax, false);				
	end;
	
end;

function FuchsGuellefass:draw()	
	if self.deckelAnimationisPlaying then
		g_currentMission:addHelpButtonText(g_i18n:getText("CloseDeckel"), InputBinding.OpenCloseDeckel);		
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("OpenDeckel"), InputBinding.OpenCloseDeckel);
	end;
end;
 
function FuchsGuellefass:onDetach()
	setVisibility(self.ManurefillSound, false);
	setVisibility(self.ManurefillSoundMax, false);		
end;

function FuchsGuellefass:onLeave()
	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelPerCent = math.floor(fillLevelNew)	
	if self.isSprayerFilling then
		if fillLevelPerCent < 95 then
			setVisibility(self.ManurefillSound, true);
			setVisibility(self.ManurefillSoundMax, false);		
		elseif fillLevelPerCent > 95 then
			setVisibility(self.ManurefillSound, false);
			setVisibility(self.ManurefillSoundMax, true);	
		end;
	else
		setVisibility(self.ManurefillSound, false);
		setVisibility(self.ManurefillSoundMax, false);				
	end;
end;
 
function FuchsGuellefass:onDeactivate()
end;
  
function FuchsGuellefass:onDeactivateSounds()
	setVisibility(self.ManurefillSound, false);
	setVisibility(self.ManurefillSoundMax, false);			
end;

--------------------
--*****EVENT1*****--
--------------------


SetdeckelAnimationisPlayingEvent = {};
SetdeckelAnimationisPlayingEvent_mt = Class(SetdeckelAnimationisPlayingEvent, Event);

InitEventClass(SetdeckelAnimationisPlayingEvent, "SetdeckelAnimationisPlayingEvent");

function SetdeckelAnimationisPlayingEvent:emptyNew()
    local self = Event:new(SetdeckelAnimationisPlayingEvent_mt);
    self.className="SetdeckelAnimationisPlayingEvent";
    return self;
end;

function SetdeckelAnimationisPlayingEvent:new(vehicle, deckelAnimationisPlaying)
    local self = SetdeckelAnimationisPlayingEvent:emptyNew()
    self.vehicle = vehicle;
	self.deckelAnimationisPlaying = deckelAnimationisPlaying;
    return self;
end;

function SetdeckelAnimationisPlayingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.deckelAnimationisPlaying = streamReadBool(streamId);
	self.vehicle:setdeckelAnimationisPlaying(self.deckelAnimationisPlaying, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetdeckelAnimationisPlayingEvent:new(self.vehicle, self.deckelAnimationisPlaying), nil, connection, self.vehicle);
    end;
end;

function SetdeckelAnimationisPlayingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.deckelAnimationisPlaying);
end;


function SetdeckelAnimationisPlayingEvent.sendEvent(vehicle, deckelAnimationisPlaying, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetdeckelAnimationisPlayingEvent:new(vehicle, deckelAnimationisPlaying), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetdeckelAnimationisPlayingEvent:new(vehicle, deckelAnimationisPlaying));
		end;
	end;
end;