--
-- fertilizerTrailer
-- Specialization for fertilizerTrailer
--
-- @author Felix "Outlaw" Sorge
-- @date  20/05/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--
--
-- edit 15/02/2013 by "Saty" http://forum.lsczech.cz
--


fertilizerTrailer = {};

function fertilizerTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function fertilizerTrailer:load(xmlFile)
	self.setTurnedOn = SpecializationUtil.callSpecializationsFunction("setTurnedOn");
	self.fertilizerInRange = SpecializationUtil.callSpecializationsFunction("fertilizerInRange");
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	self.chargeTypes = {};
	self.fillTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
	local chargeTypes = getXMLString(xmlFile, "vehicle.chargeTypes#chargeTypes");
	if chargeTypes ~= nil then
	self.chargefillNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeTypes#fillNode"));
    	local types = Utils.splitString(" ", chargeTypes);
    	for k,v in pairs(types) do
      		local desc = FruitUtil.fruitTypes[v];
            	if desc ~= nil then
                	self.chargeTypes[desc.index] = true;
            	end;
    	end;
    end;
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
	if workSound ~= nil and workSound ~= "" then
        	workSound = Utils.getFilename(workSound, self.baseDirectory); 
	        self.workSound = createSample("workSound");
	        self.workSoundEnabled = false;
	        loadSample(self.workSound, workSound, false);
	end;
	
end;


function fertilizerTrailer:update(dt)
							
   	self.inRange = false;
    local nearestDistance = 10.0;
	local px, py, pz = getWorldTranslation(self.chargefillNode);
	for i=1, table.getn(g_currentMission.vehicles) do
		local vx, vy, vz = getWorldTranslation(g_currentMission.vehicles[i].rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

		if distance < nearestDistance then
			local vehicle = g_currentMission.vehicles[i];		
			if vehicle.fillTypes ~= nil then
				for fruitType,v in pairs(vehicle.fillTypes) do
				
					if fruitType == self.currentFillType and vehicle.rootNode ~= self.rootNode and vehicle.setFillLevel ~= nil then
								
						if vehicle.fillLevel == vehicle.capacity or self.filllevel == 0 then
							self:setTurnedOn(false)
							if self.workSoundEnabled then
								stopSample(self.workSound);
								self.workSoundEnabled = false;
							end;
						elseif vehicle.fillLevel ~= vehicle.capacity and self.fillLevel ~= 0 then
							if self:getIsActiveForInput() or vehicle:getIsActiveForInput() then
								if self.turnOn then
									g_currentMission:addHelpButtonText(g_i18n:getText("fertilizerTrailer_OFF"), InputBinding.fertilizerTrailer);
									if InputBinding.hasEvent(InputBinding.fertilizerTrailer) then
										self:setTurnedOn(not self.turnOn); 
										if self.workSoundEnabled then
											stopSample(self.workSound);
											self.workSoundEnabled = false;
										end;
									end;
								else
									g_currentMission:addHelpButtonText(g_i18n:getText("fertilizerTrailer_ON"), InputBinding.fertilizerTrailer);
									if InputBinding.hasEvent(InputBinding.fertilizerTrailer)  then
										self:setTurnedOn(not self.turnOn); 
										if not self.workSoundEnabled then
											 playSample(self.workSound, 0, 1, 0);
											self.workSoundEnabled = true;   
										end; 
									end;
								end;
							end;
						
							if self.turnOn then
								self.inRange = true; 
								local deltaLevel = self.literPerSecond*dt/1000.0;
								deltaLevel = math.min(deltaLevel, vehicle.capacity - vehicle.fillLevel);
								self.fillLevel = self.fillLevel-deltaLevel;
								self:setFillLevel(self.fillLevel, self.currentFillType);
								vehicle:setFillLevel(vehicle.fillLevel + deltaLevel, self.currentFillType);	
							end; 	
									
								
					end;		
						end; 
					end;
			end;
		end;
    end; 

end;


function fertilizerTrailer:setTurnedOn(turned_on, noEventSend)
  if noEventSend ~= true then
		fertilizerTrailerEvent.sendEvent(self, turned_on);
	end;
	self.turnOn = turned_on
end


function fertilizerTrailer:fertilizerInRange(dt)

end;


function fertilizerTrailer:delete()
end;


function fertilizerTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;


function fertilizerTrailer:keyEvent(unicode, sym, modifier, isDown)

end;


function fertilizerTrailer:draw()
end;


function fertilizerTrailer:onAttach()
end; 	


function fertilizerTrailer:onDetach()
end;




fertilizerTrailerEvent = {};
fertilizerTrailerEvent_mt = Class(fertilizerTrailerEvent, Event);

InitEventClass(fertilizerTrailerEvent, "fertilizerTrailerEvent");

function fertilizerTrailerEvent:emptyNew() 
    local self = Event:new(fertilizerTrailerEvent_mt );
    self.className="fertilizerTrailerEvent";
    return self;
end;

function fertilizerTrailerEvent:new(vehicle, turned_on)
    self.vehicle = vehicle;
    self.turned_on = turned_on
    return self;
end;

function fertilizerTrailerEvent:readStream(streamId, connection) 
    local id = streamReadInt32(streamId);
	self.vehicle = networkGetObject(id);
    self.turned_on = streamReadBool(streamId);
    self:run(connection); 
end;

function fertilizerTrailerEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
    streamWriteBool(streamId, self.turned_on );     
end;

function fertilizerTrailerEvent:run(connection)  
    self.vehicle:setTurnedOn(self.turned_on, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(fertilizerTrailerEvent:new(self.vehicle, self.turned_on), nil, connection, self.object);
	end;
end;

function fertilizerTrailerEvent.sendEvent(vehicle, turned_on, noEventSend) 
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(fertilizerTrailerEvent:new(vehicle, turned_on), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(fertilizerTrailerEvent:new(vehicle, turned_on));			
		end;
	end;
end;
