-- 
-- Scrypt do beczkowozu Fortschritt HTS 100.27 by maciusboss1
-- Scrypt by maciusboss1 & Burner
-- Data: 15.07.2011 r.
-- Zakaz przerabiania i brania do swoich modeli
-- Zapraszam na www.lsmodss.pl


HTS = {};

function HTS.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function HTS:load(xmlFile)
	--RPM--
	 self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
     self.saveMinRpm = 0;
	--RPM END--

	self.rollNodes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;
	
	local korba1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.korba1#index"));
    if korba1Node ~= nil then
        self.korba1 = {};
        self.korba1.node = korba1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korba1#minRot"));
        self.korba1.minRot = {};
        self.korba1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.korba1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.korba1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korba1#maxRot"));
        self.korba1.maxRot = {};
        self.korba1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.korba1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.korba1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.korba1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korba1#rotTime"), 2)*1000;
    end;
	
	local korba2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.korba2#index"));
    if korba2Node ~= nil then
        self.korba2 = {};
        self.korba2.node = korba2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korba2#minRot"));
        self.korba2.minRot = {};
        self.korba2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.korba2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.korba2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.korba2#maxRot"));
        self.korba2.maxRot = {};
        self.korba2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.korba2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.korba2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.korba2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.korba2#rotTime"), 2)*1000;
    end;
end;

function HTS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HTS:keyEvent(unicode, sym, modifier, isDown)
end;

function HTS:update(dt)
	if self.isTurnedOn or self.isSprayerFilling then
		for _, rollNode in pairs(self.rollNodes) do
			rotate(rollNode.node, 0, 0, -dt*rollNode.speed);
		end;
		--RPM--
	  	self:setVehicleRpmUp(dt, true);
		--RPM END--
	else
		--RPM--
		self:setVehicleRpmUp(dt, false);
		--RPM END--
	end;
	if self:getIsActive() then
		if self.isTurnedOn == false and self:getIsActiveForSound() then
			if self.isSprayerFilling and not self.spraySoundEnabled then
				playSample(self.spraySound, 0, self.spraySoundVolume, 0);
				setSamplePitch(self.spraySound, self.spraySoundPitchOffset);
				self.spraySoundEnabled = true;
			elseif self.isSprayerFilling == false then
				stopSample(self.spraySound);
				self.spraySoundEnabled = false;
			end;
		end;
		if self.korba1 ~= nil then
			local x, y, z = getRotation(self.korba1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.korba1.maxRot, self.korba1.minRot, 3, self.korba1.rotTime, dt, not self.isTurnedOn);
			setRotation(self.korba1.node, unpack(newRot));
		end;
		if self.korba2 ~= nil then
			local x, y, z = getRotation(self.korba2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.korba2.maxRot, self.korba2.minRot, 3, self.korba2.rotTime, dt, not self.isSprayerFilling);
			setRotation(self.korba2.node, unpack(newRot));
		end;
	end;
end;

function HTS:draw()
end;
--RPM--
function HTS:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	for k, steerable in pairs(g_currentMission.steerables) do
		if steerable == attacherVehicle then
			self.saveMinRpm = attacherVehicle.motor.minRpm;
			if self.attacherVehicleCopy == nil then
				self.attacherVehicleCopy = self.attacherVehicle;
			end;
		elseif steerable == attacherVehicle.attacherVehicle then
			self.saveMinRpm = attacherVehicle.attacherVehicle.motor.minRpm;
			if self.attacherVehicleCopy == nil then
				self.attacherVehicleCopy = attacherVehicle.attacherVehicle;
			end;
		end;
	end;
end;
--RPM END--
--RPM--
function HTS:onDetach()
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;

end;
--RPM END--
function HTS:onLeave()
	if self.deactivateOnLeave then
        HTS.onDeactivate(self);
	end;
end;

function HTS:onDeactivate()
	self:setVehicleRpmUp(nil, false);
end;

function HTS:onDeactivateSounds()
end;

function HTS:delete()
end;
--RPM--
function HTS:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicleCopy ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicleCopy.motor.minRpm = math.max(self.attacherVehicleCopy.motor.minRpm-(dt*2), -1200);
			else
				self.attacherVehicleCopy.motor.minRpm = math.min(self.attacherVehicleCopy.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
		else
			self.attacherVehicleCopy.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicleCopy.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicleCopy.motor.minRpm);
			self.attacherVehicleCopy:setFuelFillLevel(self.attacherVehicleCopy.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;
--RPM END--