
-- Fortschritt_t088
-- by majster2009


Fortschritt_t088 = {};

function Fortschritt_t088.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Fortschritt_t088:load(xmlFile)
	self.lowerRmp = SpecializationUtil.callSpecializationsFunction("lowerRmp");
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	-----------------------------ADAPTER----------------------------
	self.walek = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek#index"));
	self.walek2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek2#index"));
	self.walek3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek3#index"));
	self.walek4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek4#index"));
	
	
	self.wom = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wom#index"));
 end;

function Fortschritt_t088:update(dt)

	if self:getIsActive() then
		
		if self.fillLevel == 0 then
			self.turnOn = false; 
			self:lowerRmp();
			if self.workSoundEnabled then
		        stopSample(self.workSound);
		        self.workSoundEnabled = false;
			end;
		end; 
		
		
		if self.turnOn then
			if not self.backupRmp then
			self.backupRmp = self.attacherVehicle.motor.minRpm;
		end; 			
		if self.attacherVehicle.motor.minRpm >= -600 then
			self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm - 10; 
			end; 
			local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
			local deltaLevel = FruitUtil.fruitIndexToDesc[self.currentFillType].literPerQm * difficultyMultiplier * self.literPerSecond;
			self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
			Utils.setEmittingState(self.dustParticleSystems, true)
			for k,cuttingArea in pairs(self.cuttingAreas) do
                local x,y,z = getWorldTranslation(cuttingArea.start);
                local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
            end;
			if not self.workSoundEnabled and self:getIsActiveForSound() then
	            playSample(self.workSound, 0, self.workSoundVolume, 0);
	            setSamplePitch(self.workSound, self.workSoundPitchOffset);
	            self.workSoundEnabled = true;
	        end;

		elseif not self.turnOn then
			Utils.setEmittingState(self.dustParticleSystems, false)
			self:lowerRmp();
			if self.workSoundEnabled then
		        stopSample(self.workSound);
		        self.workSoundEnabled = false;
			end;
		end;
	end;	
			
 
	--------------------------ADAPTER-------------------------
	if self.turnOn and self.walek ~= nil then
		rotate(self.walek, 0, dt*0.02, 0);
	end;
	if self.turnOn and self.walek2 ~= nil then
		rotate(self.walek2, 0, dt*0.02,0);
	end;
	if self.turnOn and self.walek3 ~= nil then
		rotate(self.walek3, 0, dt*0.02, 0);
	end;
	if self.turnOn and self.walek4 ~= nil then
		rotate(self.walek4, 0, dt*0.02, 0);
	end;

	if self.turnOn and self.wom ~= nil then
		rotate(self.wom, 0, 0, dt*0.03);
	end;

end;

function Fortschritt_t088:delete()
	Utils.setEmittingState(self.dustParticleSystems, false)
	self:lowerRmp();
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function Fortschritt_t088:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fortschritt_t088:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym==Input.KEY_b then
		self.turnOn = not self.turnOn;
	end;
end;		

function Fortschritt_t088:draw()
	if self.fillLevel <= 0 then
	
	end; 
		
	
	if self.turnOn then
       	g_currentMission:addExtraPrintText("Taste B: T-088 ausschalten");
    else
       	g_currentMission:addExtraPrintText("Taste B: T-088 einschalten");
    end;
end;

function Fortschritt_t088:onAttach()
end; 	


function Fortschritt_t088:onDetach()
	self.turnOn = false;
	Utils.setEmittingState(self.dustParticleSystems, false)
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
	
end

function Fortschritt_t088:lowerRmp()
	if self.backupRmp and self.attacherVehicle then
		if self.attacherVehicle.motor.minRpm <= self.backupRmp then
			self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm + 10; 
		else
			self.attacherVehicle.motor.minRpm = self.backupRmp; 
			self.backupRmp = nil; 			
		end; 	
	end; 
end;

