--
-- Fliegl371Bull
-- Specialization for Fliegl371Bull
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		31/07/11
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 and some bugfixes
--

Fliegl371Bull = {};

function Fliegl371Bull.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Fliegl371Bull:load(xmlFile)
	
	self.setIsBoardwallVisible = SpecializationUtil.callSpecializationsFunction("setIsBoardwallVisible");	
	
	local punchCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.punches#count"), 0);		
	self.punches = {};
	self.punches.fixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.punches#fixpoint"));
	self.punches.nodes = {};
	for i=1, punchCount do
		local punchName = string.format("vehicle.punches.punch%d", i);		
		local punch = {};		
		punch.node = Utils.indexToObject(self.components, getXMLString(xmlFile, punchName .. "#node"));
		punch.fixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, punchName .. "#fixpoint"));	
		local ax, ay, az = getWorldTranslation(punch.node);		
		local bx, by, bz = getWorldTranslation(punch.fixpoint);		
		punch.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);		
		table.insert(self.punches.nodes, punch);
	end;
	
	self.boardWall = {};
	self.boardWall.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.boardWall#node"));
	self.boardWall.addCapacity = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.boardWall#addCapacity"), 1500);
	self.boardWall.isVisible = true;	
	local fillType = Fillable.fillTypeIntToName[Fillable.FILLTYPE_WHEAT];
	local curve = self.fillPlanes[fillType].nodes[1].animCurve;
	self.boardWall.maxY = curve.keyframes[table.getn(curve.keyframes)].sy;
	self.boardWall.minY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.boardWall#y"), 0);
	self.capacity = self.capacity + self.boardWall.addCapacity;
	self.capacityBackup = self.capacity;
	
	
	local i = 0;
	while true do
		local key = string.format("vehicle.dischargeParticleSystems.dischargeParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		if t == "manure" then
			local currentPS = {};
			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
			self.dischargeParticleSystems[Fillable.FILLTYPE_MANURE] = currentPS;
		end;
		i = i + 1;
	end;
end;

function Fliegl371Bull:delete()
end;

function Fliegl371Bull:readStream(streamId, connection)
	self:setIsBoardwallVisible(streamReadBool(streamId), true);
end;

function Fliegl371Bull:writeStream(streamId, connection)
	streamWriteBool(streamId, self.boardWall.isVisible);
end;

function Fliegl371Bull:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fliegl371Bull:keyEvent(unicode, sym, modifier, isDown)
end;

function Fliegl371Bull:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if self.fillLevel < 0.01 then
				if InputBinding.hasEvent(InputBinding.FLIEGLBULL_DISABLE_BOARDWALL) then
					self:setIsBoardwallVisible(not self.boardWall.isVisible);
				end;
			end;
		end;
	end;		
	
	if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_CLOSING then
		for _,part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
		local bx, by, bz = getWorldTranslation(self.punches.fixpoint);
		for _,punch in pairs(self.punches.nodes) do
			local ax, ay, az = getWorldTranslation(getParent(punch.node));			
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			trans = math.min(distance-punch.distance, punch.distance);
			setTranslation(punch.node, 0, 0, trans);				
		end;
	end;
end;

function Fliegl371Bull:updateTick(dt)
end;

function Fliegl371Bull:draw()
	if self.fillLevel < 0.01 then
		if self.boardWall.isVisible then
			g_currentMission:addHelpButtonText(g_i18n:getText("FLIEGLBULL_UNDOCK_WALL"), InputBinding.FLIEGLBULL_DISABLE_BOARDWALL);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("FLIEGLBULL_DOCK_WALL"), InputBinding.FLIEGLBULL_DISABLE_BOARDWALL);
		end;
	end;
end;

function Fliegl371Bull:setIsBoardwallVisible(isVisible, noEventSend)
	BoardwallEvent.sendEvent(self, isVisible, noEventSend);	
	self.boardWall.isVisible = isVisible;
	setVisibility(self.boardWall.node, isVisible);
	local newY = self.boardWall.minY;
	if isVisible then
		self.capacity = self.capacityBackup;
		newY = self.boardWall.maxY;
	else
		self.capacity = self.capacityBackup - self.boardWall.addCapacity;
	end;
	
	for _, fillplane in pairs(self.fillPlanes) do
		for _, node in pairs(fillplane.nodes) do
			node.animCurve.keyframes[table.getn(node.animCurve.keyframes)].sy = newY;
		end;	
	end;
	
	if self.fillLevel > 0 then
		self:setFillLevel(self.fillLevel, self.currentFillType);
	end;
end;

function Fliegl371Bull:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local isVisible = Utils.getNoNil(getXMLBool(xmlFile, key.."#isBoardwallVisible"), true);		
		self:setIsBoardwallVisible(isVisible, true);
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function Fliegl371Bull:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'isBoardwallVisible="'.. tostring(self.boardWall.isVisible) .. '"';
    return attributes, nil;
end;