--
-- henly 20 (Ls_uk Modteam)
-- 10.08.2010
--
-- > www.LS-UK.info

sollevo455c = {};

function sollevo455c.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function sollevo455c:load(xmlFile)

	self.lifter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifter#index"));
	self.lifterAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterAttacher#index"));
	self.lifterArmLower = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterArmLower#index"));
	self.lifterArmLowerAttacherJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lifterArmLowerAttacherJoint#index"));

	self.lifterStartAngle = 0;
    

	
		self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
	
	self.toplink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.topLink#index"));
	self.highhitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.highHitch#index"));
 	setVisibility((self.toplink), false);
 	setVisibility((self.highhitch), true);
	
	local rotationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 5));
    end;	

 
end;

function sollevo455c:keyEvent(unicode, sym, modifier, isDown)

end;

function sollevo455c:update(dt)
	
	

	if self.lifterArmLower ~= nil and self.lifter ~= nil then
		local x,y,z = getRotation(self.lifterArmLower);
		if self.lifterStartAngle == 0 and x ~= 0 then
			self.lifterStartAngle = x;
		end;
		
		local lifterFactor = 1.58;
		local lifterRotation =  x * lifterFactor-self.lifterStartAngle * lifterFactor -0.2;
		setRotation(self.lifter, lifterRotation, y,z);
		
		local lifterAttacherFactor = 1.3;
		local lifterAttacherRotation =  self.lifterStartAngle * lifterAttacherFactor - x * lifterAttacherFactor -0.1;
		setRotation(self.lifterAttacher, lifterAttacherRotation, y,z);
	end;

	
	
		if self:getIsActive() then			
		self.setHydraulicTime = 30;	
		end;

		if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
	
		

end;


function sollevo455c:draw()

  
end;

function sollevo455c:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function sollevo455c:onEnter()
  
end;

function sollevo455c:onLeave()
 
end;

function sollevo455c:delete()

end;

function sollevo455c:mouseEvent(posX, posY, isDown, isUp, button)
end;

function sollevo455c:attachImplement(implement)
	
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
			if jointIndex == 1 then
			setVisibility((self.toplink), true);
			setVisibility((self.highhitch), false);					
			end;

	end;
		
	self.updateJoint = true;	
end;

function sollevo455c:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 then
		setVisibility((self.toplink), false);
		setVisibility((self.highhitch), true);
	end;
end;

function sollevo455c:validateAttacherJoint(implement, jointDesc, dt)
        return true;
end;