manualIgnition455cStatsEvent = {};
manualIgnition455cStatsEvent_mt = Class(manualIgnition455cStatsEvent, Event);

InitEventClass(manualIgnition455cStatsEvent, "manualIgnition455cStatsEvent");

function manualIgnition455cStatsEvent:emptyNew()
    local self = Event:new(manualIgnition455cStatsEvent_mt);
    self.className="manualIgnition455cStatsEvent";
    return self;
end;

function manualIgnition455cStatsEvent:new(vehicle)
    local self = manualIgnition455cStatsEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function manualIgnition455cStatsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.vehicle.fuelConsumption = streamReadFloat32(streamId);
	self.vehicle.distanceDriven = streamReadFloat32(streamId);
	self.vehicle.fuelUsed = streamReadFloat32(streamId);
	self.vehicle.runningTime = streamReadFloat32(streamId);
	if not connection:getIsServer() then
		g_server:broadcastEvent(manualIgnition455cStatsEvent:new(self.vehicle), nil, connection, self.vehicle);
	end;
end;

function manualIgnition455cStatsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.vehicle.fuelConsumption);
	streamWriteFloat32(streamId, self.vehicle.distanceDriven);
	streamWriteFloat32(streamId, self.vehicle.fuelUsed);
	streamWriteFloat32(streamId, self.vehicle.runningTime);
end;

function manualIgnition455cStatsEvent.sendEvent(vehicle, isTransport)
	if g_server ~= nil then
		g_server:broadcastEvent(manualIgnition455cStatsEvent:new(vehicle), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(manualIgnition455cStatsEvent:new(vehicle));
	end;
end;

