--
-- lizard2000
-- Specialization for lizard2000 mod
--
-- @author  Stefan Geiger
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

lizard2000 = {};

function lizard2000.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function lizard2000:load(xmlFile)
    hornSoundFile = Utils.getFilename("superHorn.wav", self.baseDirectory);
    self.hornSoundId = createSample("LizardHornSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
end;

function lizard2000:delete()
    delete(self.burnerSoundId);
end;

function lizard2000:mouseEvent(posX, posY, isDown, isUp, button)
end;

function lizard2000:keyEvent(unicode, sym, modifier, isDown)
end;

function lizard2000:update(dt)
	if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.LIZARD2000_SILLYHORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function lizard2000:draw()
    g_currentMission:addHelpButtonText(g_i18n:getText("Silly Horn"), InputBinding.LIZARD2000_SILLYHORN);
end;

