extraLights = {};

function extraLights.prerequisitesPresent(specializations)
    return true;
end;

function extraLights:load(xmlFile)
	
	self.animation = {};
    self.animation.animCharSet = 0;
    self.animationEnabled = false;
	self.animation.objects = {};
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blitzlicht#rootNode"));

    if rootNode ~= nil then
		local j =1;
		local parent = getParent(rootNode);
		for i= 1, getNumOfChildren(parent) do
			local index = getChildAt(parent,i-1);
			local animCharSet = getAnimCharacterSet(index);
			if animCharSet ~= 0 then
				self.animation.objects[j] = index;
				j = j+1;
			end;
		end;
		
        self.animation.animCharSet = getAnimCharacterSet(rootNode);
        if self.animation.animCharSet ~= 0 then
            self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.blitzlicht#animationClip"));
            if self.animation.clip >= 0 then
                assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
                self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.blitzlicht#speedScale"), 1);
                setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
                setAnimTrackLoopState(self.animation.animCharSet, 0, true);
            end;
        end;
    end;
	
	self.lightCount = 1;
	self.blitzing = false;
	
end;

function extraLights:delete()
end;

function extraLights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function extraLights:keyEvent(unicode, sym, modifier, isDown)
end;

function extraLights:update(dt)
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.FendRedBull936_Flashlights) then
			self.blitzing = not self.blitzing;
		end;
        if not self.animationEnabled and self.blitzing then
			enableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = true;
		end;
        if self.animationEnabled and not self.blitzing then
			setAnimTrackTime(self.animation.animCharSet, 0, 0);
			disableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = false;
			for k,v in pairs(self.animation.objects) do
				setVisibility(v,false);
			end;
		end;
	else
		if self.animationEnabled then
			setAnimTrackTime(self.animation.animCharSet, 0, 0);
			disableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = false;
			self.blitzing = false;
			for k,v in pairs(self.animation.objects) do
				setVisibility(v,false);
			end;
		end;
	end;

	local inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);	
    if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;
end;

function extraLights:draw()
end;
	
function extraLights:setLightStatus(lightCount)
end;

function extraLights:onLeave()
end;