﻿extraWeightsEvent = {};
extraWeightsEvent_mt = Class(extraWeightsEvent, Event);

InitEventClass(extraWeightsEvent, "extraWeightsEvent");

function extraWeightsEvent:emptyNew()
    local self = Event:new(extraWeightsEvent_mt);
    self.className="extraWeightsEvent";
    return self;
end;

function extraWeightsEvent:new(vehicle, mode, state)
    local self = extraWeightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
    return self;
end;

function extraWeightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function extraWeightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
end;

function extraWeightsEvent:run(connection)
	self.vehicle:MpEvent(self.mode, self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(extraWeightsEvent:new(self.vehicle, self.mode, self.state), nil, connection, self.vehicle);
    end;
end;

function extraWeightsEvent.sendEvent(vehicle, mode, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(extraWeightsEvent:new(vehicle, mode, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(extraWeightsEvent:new(vehicle, mode, state));
		end;
	end;
end;