
Chocks = {};

function Chocks.prerequisitesPresent(specializations)
	return true;
end;

function Chocks:load(xmlFile)
	self.chocks = {};
	self.chocks.driving = {};
	self.chocks.parking = {};
	local i=0;
	while true do
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.chocks.driving.chock(%d)#idx",i) ) );
		if node == nil then 
			break; 
		end;
		local entry = {};
		entry.node = node;
		table.insert(self.chocks.driving, entry);
		i=i+1;
		setVisibility(node, false);
	end;
	i=0;
	while true do
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.chocks.parking.chock(%d)#idx",i)) );
		if node == nil then 
			break; 
		end;
		local entry = {};
		entry.node = node;
		entry.trans = { getTranslation(node) };
		entry.rot = { getRotation(node) };
		entry.parent = getParent(node);
		local static = getXMLBool(xmlFile, string.format("vehicle.chocks.parking.chock(%d)#static",i) );
		entry.static = static;
		table.insert(self.chocks.parking, entry);
		i=i+1;
		setVisibility(node, true);
	end;
end;

function Chocks:delete()
	for i,j in pairs(self.chocks.parking) do
		if j.static == true then
			--unlink(j.node);
		end;
	end;
end;

function Chocks:readStream(streamId, connection)

end;

function Chocks:writeStream(streamId, connection)

end;

function Chocks:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Chocks:keyEvent(unicode, sym, modifier, isDown)

end;

function Chocks:update(dt)
end;

function Chocks:updateTick(dt)

end;

function Chocks:onAttach(attacherVehicle)
	for i,j in pairs(self.chocks.driving) do
		setVisibility(j.node, true);
	end;

	for i,j in pairs(self.chocks.parking) do
		setVisibility(j.node, false);
		--[[if j.static == true then
			unlink(j.node);
			link(j.parent,j.node);
			setRigidBodyType(j.node, "None");
			setTranslation(j.node, unpack(j.trans));
			setRotation(j.node, unpack(j.rot));
		end;]]--
	end;
	
end;

function Chocks:onDetach()
	for i,j in pairs(self.chocks.driving) do
		setVisibility(j.node, false);
	end;
	
	for i,j in pairs(self.chocks.parking) do
		setVisibility(j.node, true);
		--[[if j.static == true then
			local x, y, z = getWorldTranslation(j.node);
			local rx, ry, rz = getWorldRotation(j.node);
			unlink(j.node);
			link(getRootNode(), j.node);
			setTranslation(j.node, x, y, z);
			setRotation(j.node, rx, ry, rz);
			setRigidBodyType(j.node, "Static");
		end;]]--
	end;
	
end;

function Chocks:draw()

end;