--
-- WorkLights script by Zippo
-- 

wLights = {};

function wLights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function wLights:load(xmlFile)
	local numwLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.wLights#count"), 0);
    self.wLights = {};
    for i=1, numwLights do
        local worklightnamei = string.format("vehicle.wLights.workLight%d", i);
        self.wLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.wLights[i], false);
    end;
	self.wLightsActive = false;
end;

function wLights:delete()
	for k, worklight in pairs(self.wLights) do
		setVisibility(worklight, false);
	end;
	self.wLightsActive = false;
end;

function wLights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wLights:keyEvent(unicode, sym, modifier, isDown)
end;

function wLights:update(dt)
	if self.isMotorStarted and self.isEntered then
		if InputBinding.hasEvent(InputBinding.WLIGHTS) then
			self.wLightsActive = not self.wLightsActive;
		end;
	
		for k, worklight in pairs(self.wLights) do
			setVisibility(worklight, self.wLightsActive);
		end;
	end;
end;

function wLights:onLeave()
	for k, worklight in pairs(self.wLights) do
		setVisibility(worklight, false);
	end;
	self.wLightsActive = false;
end;

function wLights:draw()
	if self.isMotorStarted then
    		g_currentMission:addHelpButtonText(g_i18n:getText("wLights"), InputBinding.WLIGHTS);
		
    end;
end;

