--[[************************************************************************************************************************************************************
	
	swingingAxles v1.0
	
	09/2013 by Saty / http://forum.lsczech.cz
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
	--------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	Zapis do XML souboru stroje :
	*****************************
	
	<swingingAxles>
		<part axleNode="0>7" axleFixNode="0>1|0" wheelIndex="1" driveShaftNode="0>7|0" steeringNode="0>7|1" reverse="false" />
	</swingingAxles>
	
	
	Vysvetlivky k funkcim:
	
	part				- jednotliva ramena naprav (neomezeny pocet)
	axleNode			- index kyvneho remene
	axleFixNode			- index bodu kam se rameno pripojuje (funguje podobne jako movingParts)
	wheelIndex			- cislo kola, podle ktereho se otaci poloosa a zataci kolo (pri nezadani defaultni hodnota "1" = 1. kolo zapsane ve wheels)
	driveShaftNode			- index poloosy (nemusi byt zadano)
	steeringNode			- index casti ktera zataci (nemusi byt zadano)
	reverse				- v pripade potreby otoci smer otaceni poloosy a zataceni oproti kolu (pri nezadani defaultni hodnota "false")
	
	--------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	Zapis do souboru modDesc.xml :
	******************************
	
	vsadit do <specializations> :
		<specialization name="swingingAxles"  className="swingingAxles"  filename="scripts/swingingAxles.lua"/>
	
	vsadit do <vehicleTypes> :
		<specialization name="swingingAxles" />
	
************************************************************************************************************************************************************]]--

swingingAxles = {};

function swingingAxles.prerequisitesPresent(specializations)
    return true;
end;

function swingingAxles:load(xmlFile)
	self.swingingAxles = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.swingingAxles.part(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local axleNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#axleNode"));
		local axleFixNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#axleFixNode"));
		local driveShaftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#driveShaftNode"));
		local steeringNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#steeringNode"));
		local reverse = Utils.getNoNil(getXMLBool(xmlFile, key .."#reverse"), false);
		local wheelIndex = Utils.getNoNil(getXMLInt(xmlFile, key.."#wheelIndex"), 1);
		if axleNode ~= nil then
			table.insert(self.swingingAxles, {axleNode=axleNode, axleFixNode=axleFixNode, driveShaftNode=driveShaftNode, wheelIndex=wheelIndex, steeringNode=steeringNode, reverse=reverse});
		end;
		i = i + 1;
	end;
end;

function swingingAxles:updateTick(dt)
	if self.swingingAxles ~= nil and self.wheels ~= nil then
		for _, part in pairs(self.swingingAxles) do
			local x, y, z, x1, y1, z1 = {};
			local ax, ay, az = getWorldTranslation(part.axleNode);
			local bx, by, bz = getWorldTranslation(part.axleFixNode);
			local cx, cy, cz = worldDirectionToLocal(getParent(part.axleNode), bx-ax, by-ay, bz-az);
			setDirection(part.axleNode, cx, cy, cz, 0, -1, 0);
			
			if part.driveShaftNode ~= nil then
				x, y, z = getRotation(self.wheels[part.wheelIndex].driveNode);
				x1, y1, z1 = getRotation(part.driveShaftNode);
				if part.reverse then
					setRotation(part.driveShaftNode, -x, y1, z1);
				else
					setRotation(part.driveShaftNode, x, y1, z1);
				end;
			end;
			if part.steeringNode ~= nil then
				x, y, z = getRotation(self.wheels[part.wheelIndex].repr);
				x1, y1, z1 = getRotation(part.steeringNode);
				if part.reverse then
					setRotation(part.steeringNode, x1, -y, z1);
				else
					setRotation(part.steeringNode, x1, y, z1);
				end;
			end;
		end;
	end;
end;

function swingingAxles:update(dt)
end;

function swingingAxles:delete()
end;

function swingingAxles:mouseEvent(posX, posY, isDown, isUp, button)
end;

function swingingAxles:keyEvent(unicode, sym, modifier, isDown)
end;

function swingingAxles:draw()
end;