--
-- TebbeHS180
-- Class for the Tebbe HS 180 
--
-- @author  Stefan MAurUS
-- @date  20/11/11
--
-- contains the ManureSpreader.lua by GIANTS Software GmbH
 
TebbeHS180 = {};
  
function TebbeHS180.prerequisitesPresent(specializations)
      return SpecializationUtil.hasSpecialization(Sprayer, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function TebbeHS180:load(xmlFile)
    self.setIsTurnedOn = Utils.prependedFunction(self.setIsTurnedOn, TebbeHS180.setIsTurnedOn); -- call our function before the one of the sprayer (so self.isTurnedOn ~= isTurnedOn still works)
	self.setDoorHigh = SpecializationUtil.callSpecializationsFunction("setDoorHigh"); -- Neue Funktion -- Parameter int(self.doorhigh and noEventSend)
	self.setFlapOpen = SpecializationUtil.callSpecializationsFunction("setFlapOpen"); -- Neue Funktion -- Parameter int(self.doorhigh and noEventSend)
	 	 
      self.rotatingPartsAnimTime = 0;
  
      self.rotatingParts = {};
      local i=0;
      while true do
          local baseName = string.format("vehicle.rotatingParts.rotatingPart(%d)", i);
          if not hasXMLProperty(xmlFile, baseName) then
              break;
          end;
          local entry = {};
          entry.node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.. "#node"));
          entry.speed = Utils.getNoNil(getXMLFloat(xmlFile, baseName.. "#speed"), 0.005);
          if entry.node ~= nil then
              table.insert(self.rotatingParts, entry);
          end;
          i = i+1;
      end;
  
      local doorAnimation = {}; --Stufe 1
      doorAnimation.name = getXMLString(xmlFile, "vehicle.doorAnimation#name");
      doorAnimation.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.doorAnimation#openSpeedScale"), 1);
      doorAnimation.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.doorAnimation#closeSpeedScale"), -doorAnimation.openSpeedScale);
      if doorAnimation.name ~= nil then
          self.doorAnimation = doorAnimation;
      end;
      local doorAnimation1 = {}; --Stufe 2
      doorAnimation1.name = getXMLString(xmlFile, "vehicle.doorAnimation1#name");
      doorAnimation1.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.doorAnimation1#openSpeedScale"), 1);
      doorAnimation1.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.doorAnimation1#closeSpeedScale"), -doorAnimation1.openSpeedScale);
      if doorAnimation1.name ~= nil then
          self.doorAnimation1 = doorAnimation1;
      end;
      local doorAnimation2 = {};  --Stufe 3 (Max.)
      doorAnimation2.name = getXMLString(xmlFile, "vehicle.doorAnimation2#name");
      doorAnimation2.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.doorAnimation2#openSpeedScale"), 1);
      doorAnimation2.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.doorAnimation2#closeSpeedScale"), -doorAnimation2.openSpeedScale);
      if doorAnimation2.name ~= nil then
          self.doorAnimation2 = doorAnimation2;
      end;	  
	  
      local flapAnimation = {};
      flapAnimation.name = getXMLString(xmlFile, "vehicle.flapAnimation#name");
      flapAnimation.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.flapAnimation#openSpeedScale"), 1);
      flapAnimation.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.flapAnimation#closeSpeedScale"), -flapAnimation.openSpeedScale);
      if flapAnimation.name ~= nil then
          self.flapAnimation = flapAnimation;
      end;  
	  
	  -- Panel
      local PanelDrehhebelState1 = {};
      PanelDrehhebelState1.name = getXMLString(xmlFile, "vehicle.PanelDrehhebelState1#name");
      PanelDrehhebelState1.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelDrehhebelState1#openSpeedScale"), 1);
      PanelDrehhebelState1.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelDrehhebelState1#closeSpeedScale"), -PanelDrehhebelState1.openSpeedScale);
      if PanelDrehhebelState1.name ~= nil then
          self.PanelDrehhebelState1 = PanelDrehhebelState1;
      end;  
      local PanelDrehhebelState2 = {};
      PanelDrehhebelState2.name = getXMLString(xmlFile, "vehicle.PanelDrehhebelState2#name");
      PanelDrehhebelState2.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelDrehhebelState2#openSpeedScale"), 1);
      PanelDrehhebelState2.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelDrehhebelState2#closeSpeedScale"), -PanelDrehhebelState2.openSpeedScale);
      if PanelDrehhebelState2.name ~= nil then
          self.PanelDrehhebelState2 = PanelDrehhebelState2;
      end;  
      local PanelDrehhebelState3 = {};
      PanelDrehhebelState3.name = getXMLString(xmlFile, "vehicle.PanelDrehhebelState3#name");
      PanelDrehhebelState3.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelDrehhebelState3#openSpeedScale"), 1);
      PanelDrehhebelState3.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelDrehhebelState3#closeSpeedScale"), -PanelDrehhebelState3.openSpeedScale);
      if PanelDrehhebelState3.name ~= nil then
          self.PanelDrehhebelState3 = PanelDrehhebelState3;
      end;  
      local PanelDrehhebelState4 = {};
      PanelDrehhebelState4.name = getXMLString(xmlFile, "vehicle.PanelDrehhebelState4#name");
      PanelDrehhebelState4.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelDrehhebelState4#openSpeedScale"), 1);
      PanelDrehhebelState4.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelDrehhebelState4#closeSpeedScale"), -PanelDrehhebelState4.openSpeedScale);
      if PanelDrehhebelState4.name ~= nil then
          self.PanelDrehhebelState4 = PanelDrehhebelState4;
      end;  

      local PanelHebelKlein1 = {};
      PanelHebelKlein1.name = getXMLString(xmlFile, "vehicle.PanelHebelKlein1#name");
      PanelHebelKlein1.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelHebelKlein1#openSpeedScale"), 1);
      PanelHebelKlein1.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelHebelKlein1#closeSpeedScale"), -PanelHebelKlein1.openSpeedScale);
      if PanelHebelKlein1.name ~= nil then
          self.PanelHebelKlein1 = PanelHebelKlein1;
      end;  
      local PanelHebelKlein2 = {};
      PanelHebelKlein2.name = getXMLString(xmlFile, "vehicle.PanelHebelKlein2#name");
      PanelHebelKlein2.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelHebelKlein2#openSpeedScale"), 1);
      PanelHebelKlein2.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelHebelKlein2#closeSpeedScale"), -PanelHebelKlein2.openSpeedScale);
      if PanelHebelKlein2.name ~= nil then
          self.PanelHebelKlein2 = PanelHebelKlein2;
      end;  
      local PanelHebelGross1 = {};
      PanelHebelGross1.name = getXMLString(xmlFile, "vehicle.PanelHebelGross1#name");
      PanelHebelGross1.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelHebelGross1#openSpeedScale"), 1);
      PanelHebelGross1.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelHebelGross1#closeSpeedScale"), -PanelHebelGross1.openSpeedScale);
      if PanelHebelGross1.name ~= nil then
          self.PanelHebelGross1 = PanelHebelGross1;
      end;  
      local PanelHebelGross2 = {};
      PanelHebelGross2.name = getXMLString(xmlFile, "vehicle.PanelHebelGross2#name");
      PanelHebelGross2.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelHebelGross2#openSpeedScale"), 1);
      PanelHebelGross2.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PanelHebelGross2#closeSpeedScale"), -PanelHebelGross2.openSpeedScale);
      if PanelHebelGross2.name ~= nil then
          self.PanelHebelGross2 = PanelHebelGross2;
      end;  	  
	  
	
	self.hayBase = {};
	self.hayBase.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kratzboden#index"));
	self.hayBase.unloadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.kratzboden#unloadingSpeed"), 0.001);
	self.hayBase.unloadingDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.kratzboden#unloadingDirection"), 1);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);

	self.flapopen = false;
	self.printWarningTime = 0;
	self.printWarningTimeIsEmpty = 0;
		
    local BedienboxHUD = Utils.getFilename("HUD/HUD.dds", self.baseDirectory);
    self.BedienboxHUD = Overlay:new("BedienboxHUD",BedienboxHUD, 0,0,0.39,0.48);
	self.HudRender = false;	
	
    local HUD_high_0 = Utils.getFilename("HUD/HUD_high_0.dds", self.baseDirectory);
    self.HUD_high_0 = Overlay:new("HUD_high_0",HUD_high_0, 0,0,0.39,0.48);
	
    local HUD_high_1 = Utils.getFilename("HUD/HUD_high_1.dds", self.baseDirectory);
    self.HUD_high_1 = Overlay:new("HUD_high_1",HUD_high_1, 0,0,0.39,0.48);
	
    local HUD_high_2 = Utils.getFilename("HUD/HUD_high_2.dds", self.baseDirectory);
    self.HUD_high_2 = Overlay:new("HUD_high_2",HUD_high_2, 0,0,0.39,0.48);
	
    local HUD_high_3 = Utils.getFilename("HUD/HUD_high_3.dds", self.baseDirectory);
    self.HUD_high_3 = Overlay:new("HUD_high_3",HUD_high_3, 0,0,0.39,0.48);
	
    local HUD_higher_0 = Utils.getFilename("HUD/HUD_higher_0.dds", self.baseDirectory);
    self.HUD_higher_0 = Overlay:new("HUD_higher_0",HUD_higher_0, 0,0,0.39,0.48);
	self.HUD_higher_0_HudRender = false;	
	
    local HUD_higher_1 = Utils.getFilename("HUD/HUD_higher_1.dds", self.baseDirectory);
    self.HUD_higher_1 = Overlay:new("HUD_higher_1",HUD_higher_1, 0,0,0.39,0.48);
	self.HUD_higher_1_HudRender = false;
	
	local HUD_less_0 = Utils.getFilename("HUD/HUD_less_0.dds", self.baseDirectory);
    self.HUD_less_0 = Overlay:new("HUD_less_0",HUD_less_0, 0,0,0.39,0.48);
	self.HUD_less_0_HudRender = false;
	
	local HUD_less_1 = Utils.getFilename("HUD/HUD_less_1.dds", self.baseDirectory);
    self.HUD_less_1 = Overlay:new("HUD_less_1",HUD_less_1, 0,0,0.39,0.48);
	self.HUD_less_1_HudRender = false;	
	
	local HUD_Klappe_close = Utils.getFilename("HUD/HUD_Klappe_close.dds", self.baseDirectory);
    self.HUD_Klappe_close = Overlay:new("HUD_Klappe_close",HUD_Klappe_close, 0,0,0.39,0.48);
	
	local HUD_Klappe_open = Utils.getFilename("HUD/HUD_Klappe_open.dds", self.baseDirectory);
    self.HUD_Klappe_open = Overlay:new("HUD_Klappe_open",HUD_Klappe_open, 0,0,0.39,0.48);
	
	local HUD_turnOn_off = Utils.getFilename("HUD/HUD_turnOn_off.dds", self.baseDirectory);
    self.HUD_turnOn_off = Overlay:new("HUD_turnOn_off",HUD_turnOn_off, 0,0,0.39,0.48);
	
	local HUD_turnOn_on = Utils.getFilename("HUD/HUD_turnOn_on.dds", self.baseDirectory);
    self.HUD_turnOn_on = Overlay:new("HUD_turnOn_on",HUD_turnOn_on, 0,0,0.39,0.48);
	
	self.doorhigh = 0;
	self.doorr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.door#index"));	
	self.Plane = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plane#index"));	
	self.startIndexHelp = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cuttingAreasHelp#startIndex"));	
	self.widthIndexHelp = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cuttingAreasHelp#widthIndex"));	
	
	self.Aufbau = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Aufbau#index"));		
	self.AufbauIsVisible = false;
	
	self.hasInteractivControl = false;
	self.higherTime = 0;
	self.lessTime = 0;
	
	self.showPS = false;
	self.particleSystemStufe1 = {};
    local i = 0;
    while true do
        local systemi = string.format("vehicle.particleSystemStufe1.system(%d)", i);
		local indexi = Utils.indexToObject(self.components, getXMLString(xmlFile, systemi .. "#index"));
		if indexi == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystemStufe1, systemi, indexi, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	self.showPS = false;
	self.particleSystemStufe2 = {};
    local i = 0;
    while true do
        local system2i = string.format("vehicle.particleSystemStufe2.system(%d)", i);
		local index2i = Utils.indexToObject(self.components, getXMLString(xmlFile, system2i .. "#index"));
		if index2i == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystemStufe2, system2i, index2i, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	self.showPS = false;
	self.particleSystemStufe3 = {};
    local i = 0;
    while true do
        local system3i = string.format("vehicle.particleSystemStufe3.system(%d)", i);
		local index3i = Utils.indexToObject(self.components, getXMLString(xmlFile, system3i .. "#index"));
		if index3i == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystemStufe3, system3i, index3i, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	self.showPS = false;
	self.particleSystemWalzePart1 = {};
    local i = 0;
    while true do
        local system4i = string.format("vehicle.particleSystemWalzePart1.system(%d)", i);
		local index4i = Utils.indexToObject(self.components, getXMLString(xmlFile, system4i .. "#index"));
		if index4i == nil then
			break;
		end; 
        Utils.loadStaticParticleSystem(xmlFile, self.particleSystemWalzePart1, system4i, index4i, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	self.showPS = false;
	self.particleSystemWalzePart2 = {};
    local i = 0;
    while true do
        local system6i = string.format("vehicle.particleSystemWalzePart2.system(%d)", i);
		local index6i = Utils.indexToObject(self.components, getXMLString(xmlFile, system6i .. "#index"));
		if index6i == nil then
			break;
		end; 
        Utils.loadStaticParticleSystem(xmlFile, self.particleSystemWalzePart2, system6i, index6i, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	self.showPS = false;
	self.particleSystemMist = {};
    local i = 0;
    while true do
        local system5i = string.format("vehicle.particleSystemMist.system(%d)", i);
		local index5i = Utils.indexToObject(self.components, getXMLString(xmlFile, system5i .. "#index"));
		if index5i == nil then
			break;
		end; 
        Utils.loadStaticParticleSystem(xmlFile, self.particleSystemMist, system5i, index5i, false, nil, self.baseDirectory)		
		i = i +1;		
    end;	
end;

function TebbeHS180:delete()
	Utils.deleteParticleSystem(self.particleSystemMist);
	Utils.deleteParticleSystem(self.particleSystemWalzePart2);
	Utils.deleteParticleSystem(self.particleSystemWalzePart1);
	Utils.deleteParticleSystem(self.particleSystemStufe3);
	Utils.deleteParticleSystem(self.particleSystemStufe2);	
	Utils.deleteParticleSystem(self.particleSystemStufe1);	
end;

function TebbeHS180:readStream(streamId, connection) -- wird nur beim Joinen aufgerufen ;)
	self:setDoorHigh(streamReadInt8(streamId), true); -- hier rufen wir unsere Funktion mit dem empfangenen Wert von self.doorhigh auf --
	self:setFlapOpen(streamReadBool(streamId), true);	
end;

function TebbeHS180:writeStream(streamId, connection) -- wird nur beim Joinen aufgerufen ;)
	streamWriteInt8(streamId, self.doorhigh); -- hier bergeben wir den Wert, den self.doorhigh hat, an andere Mitspieler --
	streamWriteBool(streamId, self.flapopen); -- "streamWriteBool" weil wir ja einen Bool (true oder false) bergeben mchten --
end;

function TebbeHS180:setDoorHigh(int, noEventSend)
	if int > 3 then 
		int = 3;
	elseif int < 0 then
		int = 0;
	end;
	
	self.doorhigh = int;
	SetDoorHighEvent.sendEvent(self, int, noEventSend); -- hier rufen wir das Event auf und bergeben den/die Werte --
end;

function TebbeHS180:setFlapOpen(bool, noEventSend)
	self.flapopen = bool;
	SetFlapOpenEvent.sendEvent(self, bool, noEventSend);
end;
 
function TebbeHS180:mouseEvent(posX, posY, isDown, isUp, button)
	if not self.hasInteractivControl then
		if self.HudRender then
			InputBinding.setShowMouseCursor(true);
		else
			InputBinding.setShowMouseCursor(false);					
		end;
	end;
	
	if self.HudRender then
		if isDown and button == Input.MOUSE_BUTTON_LEFT then
		
			-- Turn on
			if (posY > 0.21 and posY < 0.24) and (posX > 0.16 and posX < 0.19) then
				if self.doorhigh > 0 then
					self:setIsTurnedOn(not self.isTurnedOn);
				else	
					self.printWarningTime = self.time + 3000;
				end;
				if self.fillLevel <= 0 then
					self.printWarningTimeIsEmpty = self.time + 3000;
				end;				
			end;	
			
			-- Klappe
			if (posY > 0.04 and posY < 0.08) and (posX > 0.05 and posX < 0.09) then
				self:setFlapOpen(not self.flapopen);	
			end;	
			
			-- Rueckwand up
			if (posY > 0.17 and posY < 0.22) and (posX > 0.26 and posX < 0.31) and self.doorhigh < 3 and self.doorhigh >= 0 then --## Brauchen wir nicht unbedingt mehr, weil die Funktion, self.doorHigh nicht grer als 3 bz. kleiner als 0 gehen lsst ;) --
				self:setDoorHigh(self.doorhigh+1);
				self.higherTime = self.time + 2000;	
			end;
			-- Rueckwand down
			if (posY > 0.17 and posY < 0.22) and (posX > 0.02 and posX < 0.1) and self.doorhigh <= 3 and self.doorhigh >= 1 then --## Brauchen wir nicht unbedingt mehr, weil die Funktion, self.doorHigh nicht grer als 3 bz. kleiner als 0 gehen lsst ;) --
				self:setDoorHigh(self.doorhigh-1);
				self.lessTime = self.time + 2000;
			end;				
		end;
	end;
end;
 
function TebbeHS180:keyEvent(unicode, sym, modifier, isDown)
end;
 
function TebbeHS180:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TEBBE_doorhighMore) and self.doorhigh < 3 and self.doorhigh >= 0 then
			self:setDoorHigh(self.doorhigh+1);	
			self.higherTime = self.time + 1250;			
		end;	
	
		if InputBinding.hasEvent(InputBinding.TEBBE_doorhighLess) and self.doorhigh <= 3 and self.doorhigh >= 1 then
			self:setDoorHigh(self.doorhigh-1);		
			self.lessTime = self.time + 1250;
		end;

		if InputBinding.hasEvent(InputBinding.TEBBE_flapanimation) then
			self:setFlapOpen(not self.flapopen);	
		end;
		
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and self.doorhigh == 0 then
			self.printWarningTime = self.time + 3000;
		end;
		
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and self.fillLevel <= 0 then
			self.printWarningTimeIsEmpty = self.time + 3000;
		end;		
		
		if InputBinding.hasEvent(InputBinding.TEBBE_HUD_ONOFF) and not self.hasInteractivControl then
			self.HudRender = not self.HudRender;			
		end;		
	end;
end;

function TebbeHS180:updateTick(dt)
	
    if self.isTurnedOn and self:getIsActive() then
          -- update rotatingParts
        self.rotatingPartsAnimTime = self.rotatingPartsAnimTime + dt;
        for _, rotatingPart in ipairs(self.rotatingParts) do
            setRotation(rotatingPart.node, 0 , rotatingPart.speed*self.rotatingPartsAnimTime, 0);
        end;
		setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.unloadingSpeed,0,0,0,false);
		self.allowDis = false;		
		local Sx, Sy, Sz = getScale(self.Plane);
		if Sy > 0.6 then
			Utils.setEmittingState(self.particleSystemWalzePart1, true);
			Utils.setEmittingState(self.particleSystemWalzePart2, true);
		elseif Sy < 0.6 then
			Utils.setEmittingState(self.particleSystemWalzePart1, true);
			Utils.setEmittingState(self.particleSystemWalzePart2, false);	
		end;
		self:playAnimation(self.PanelHebelKlein2.name, self.PanelHebelKlein2.openSpeedScale, self:getAnimationTime(self.PanelHebelKlein2.name), true);
	else
		setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
		self.allowDis = false;	
		Utils.setEmittingState(self.particleSystemWalzePart1, false);
		Utils.setEmittingState(self.particleSystemWalzePart2, false);		
		self:playAnimation(self.PanelHebelKlein2.name, self.PanelHebelKlein2.closeSpeedScale, self:getAnimationTime(self.PanelHebelKlein2.name), true);		
    end;
	
	local aufbauIsVisibil = getVisibility(self.Aufbau)
	if aufbauIsVisibil == true then
		self.AufbauIsVisible = true;
	else
		self.AufbauIsVisible = false;
	end;
	
	if self.attacherVehicle ~= nil then
			if self.attacherVehicle.addControlPanel ~= nil then
				self.hasInteractivControl = true;
				if self.attacherVehicle.isMouseActive then
					self.HudRender = true;
				else
					self.HudRender = false;
				end;
			end;
			if self.attacherVehicle.addControlPanel == nil then
				self.hasInteractivControl = false;
			end;
	end;
	
	--Left CuttingHelp
    local x3,y3,z3 = getTranslation(self.startIndexHelp);
    local x2,y2,z2 = getWorldTranslation(self.startIndexHelp);
    local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x2, 0, z2);
	local unterschied1 = y2-terrainHeight;
	if unterschied1 > 1 and unterschied1 < 1.1 then
		local New1y3 = y3-0.01;
		setTranslation(self.startIndexHelp, x3, New1y3, z3);	
	elseif unterschied1 > 1.1 and unterschied1 < 1.5 then
		local New2y3 = y3-0.05;
		setTranslation(self.startIndexHelp, x3, New2y3, z3);	
	elseif unterschied1 > 1.5 then
		local New3y3 = y3-0.2;
		setTranslation(self.startIndexHelp, x3, New3y3, z3);
	elseif unterschied1 < 1 and unterschied1 > 0.9 then
		local New4y3 = y3+0.01;
		setTranslation(self.startIndexHelp, x3, New4y3, z3);		
	elseif unterschied1 < 0.9 and unterschied1 > 0.5 then
		local New5y3 = y3+0.05;
		setTranslation(self.startIndexHelp, x3, New5y3, z3);	
	elseif unterschied1 < 0.5 then
		local New6y3 = y3+0.2;
		setTranslation(self.startIndexHelp, x3, New6y3, z3);			
	end;
		
	--Right CuttingHelp
    local x5,y5,z5 = getTranslation(self.widthIndexHelp);
    local x4,y4,z4 = getWorldTranslation(self.widthIndexHelp);
    local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x4, 0, z4);
	local unterschied = y4-terrainHeight;

	if unterschied > 1 and unterschied < 1.1 then
		local New1y5 = y5-0.01;
		setTranslation(self.widthIndexHelp, x5, New1y5, z5);	
	elseif unterschied > 1.1 and unterschied < 1.5 then
		local New2y5 = y5-0.05;
		setTranslation(self.widthIndexHelp, x5, New2y5, z5);	
	elseif unterschied > 1.5 then
		local New3y5 = y5-0.2;
		setTranslation(self.widthIndexHelp, x5, New3y5, z5);
	elseif unterschied < 1 and unterschied > 0.9 then
		local New4y5 = y5+0.01;
		setTranslation(self.widthIndexHelp, x5, New4y5, z5);		
	elseif unterschied < 0.9 and unterschied > 0.5 then
		local New5y5 = y5+0.05;
		setTranslation(self.widthIndexHelp, x5, New5y5, z5);	
	elseif unterschied < 0.5 then
		local New6y5 = y5+0.2;
		setTranslation(self.widthIndexHelp, x5, New6y5, z5);			
	end;
	
	if self.flapopen then
		self:playAnimation(self.flapAnimation.name, self.flapAnimation.openSpeedScale, self:getAnimationTime(self.flapAnimation.name), true);
		self:playAnimation(self.PanelHebelKlein1.name, self.PanelHebelKlein1.openSpeedScale, self:getAnimationTime(self.PanelHebelKlein1.name), true);
	else
		self:playAnimation(self.flapAnimation.name, self.flapAnimation.closeSpeedScale, self:getAnimationTime(self.flapAnimation.name), true);
		self:playAnimation(self.PanelHebelKlein1.name, self.PanelHebelKlein1.closeSpeedScale, self:getAnimationTime(self.PanelHebelKlein1.name), true);		
	end;
	
	if self.higherTime > self.time then
		self:playAnimation(self.PanelHebelGross2.name, self.PanelHebelGross2.openSpeedScale, self:getAnimationTime(self.PanelHebelGross2.name), true);
		self.HUD_higher_0_HudRender = false;	
		self.HUD_higher_1_HudRender = true;		
	else
		self:playAnimation(self.PanelHebelGross2.name, self.PanelHebelGross2.closeSpeedScale, self:getAnimationTime(self.PanelHebelGross2.name), true);
		self.HUD_higher_0_HudRender = true;	
		self.HUD_higher_1_HudRender = false;			
	end;
	
	if self.lessTime > self.time then
		self:playAnimation(self.PanelHebelGross1.name, self.PanelHebelGross1.openSpeedScale, self:getAnimationTime(self.PanelHebelGross1.name), true);
		self.HUD_less_1_HudRender = true;		
		self.HUD_less_0_HudRender = false;		
	else
		self:playAnimation(self.PanelHebelGross1.name, self.PanelHebelGross1.closeSpeedScale, self:getAnimationTime(self.PanelHebelGross1.name), true);
		self.HUD_less_1_HudRender = false;		
		self.HUD_less_0_HudRender = true;				
	end;
		
	local dx, dy, dz = getTranslation(self.doorr);
	if dy > 2.8 and dy < 3 then --1
		self.hayBase.unloadingSpeed = 0.30;
		self.sprayLitersPerSecond[self.currentFillType] = 240;
		if self.isTurnedOn then
			Utils.setEmittingState(self.particleSystemStufe3, false);
			Utils.setEmittingState(self.particleSystemStufe2, false);	
			Utils.setEmittingState(self.particleSystemStufe1, true);				
		else
			Utils.setEmittingState(self.particleSystemStufe1, false);		
			Utils.setEmittingState(self.particleSystemStufe2, false);		
			Utils.setEmittingState(self.particleSystemStufe3, false);			
		end;		
	end;
	if dy > 3.2 and dy < 3.4 then --2	
		self.hayBase.unloadingSpeed = 0.60;	
		self.sprayLitersPerSecond[self.currentFillType] = 360;	
		if self.isTurnedOn then
			Utils.setEmittingState(self.particleSystemStufe3, false);
			Utils.setEmittingState(self.particleSystemStufe2, true);	
			Utils.setEmittingState(self.particleSystemStufe1, false);				
		else
			Utils.setEmittingState(self.particleSystemStufe1, false);		
			Utils.setEmittingState(self.particleSystemStufe2, false);		
			Utils.setEmittingState(self.particleSystemStufe3, false);			
		end;		
	end;
	if dy < 3.9 and dy > 3.7 then --3
		self.hayBase.unloadingSpeed = 0.90;	
		self.sprayLitersPerSecond[self.currentFillType] = 450;	
		if self.isTurnedOn then
			Utils.setEmittingState(self.particleSystemStufe3, true);
			Utils.setEmittingState(self.particleSystemStufe2, false);	
			Utils.setEmittingState(self.particleSystemStufe1, false);				
		else
			Utils.setEmittingState(self.particleSystemStufe1, false);		
			Utils.setEmittingState(self.particleSystemStufe2, false);		
			Utils.setEmittingState(self.particleSystemStufe3, false);			
		end;				
	end;
	if dy > 2.5 and dy < 2.7 then --0	
		self.hayBase.unloadingSpeed = 0;	
		self.sprayLitersPerSecond[self.currentFillType] = 1;	
		Utils.setEmittingState(self.particleSystemStufe1, false);		
		Utils.setEmittingState(self.particleSystemStufe2, false);		
		Utils.setEmittingState(self.particleSystemStufe3, false);		
		self.isTurnedOn = false;
	end;
	
	if self.fillLevel > 0 then
		Utils.setEmittingState(self.particleSystemMist, true);
	else
		Utils.setEmittingState(self.particleSystemMist, false);	
	end;	
	
	--door animations
	if self.doorhigh == 0 then
		if dy > 2.8 and dy < 3 then  
			self:playAnimation(self.doorAnimation.name, self.doorAnimation.closeSpeedScale, self:getAnimationTime(self.doorAnimation.name), true);
		elseif dy > 3.2 and dy < 3.4 then 
			self:playAnimation(self.doorAnimation1.name, self.doorAnimation1.closeSpeedScale, self:getAnimationTime(self.doorAnimation1.name), true);
		elseif dy < 3.9 and dy > 3.7 then
			self:playAnimation(self.doorAnimation2.name, self.doorAnimation2.closeSpeedScale, self:getAnimationTime(self.doorAnimation2.name), true);	
		end;
		self:playAnimation(self.PanelDrehhebelState1.name, self.PanelDrehhebelState1.openSpeedScale, self:getAnimationTime(self.PanelDrehhebelState1.name), true);			
	end;
	
	if self.doorhigh == 1 then
		if dy > 2.5 and dy < 2.7 then 
			self:playAnimation(self.doorAnimation.name, self.doorAnimation.openSpeedScale, self:getAnimationTime(self.doorAnimation.name), true);
		elseif dy > 3.2 and dy < 3.4 then
			self:playAnimation(self.doorAnimation1.name, self.doorAnimation1.closeSpeedScale, self:getAnimationTime(self.doorAnimation1.name), true);
		elseif dy < 3.9 and dy > 3.7 then
			self:playAnimation(self.doorAnimation2.name, self.doorAnimation2.closeSpeedScale, self:getAnimationTime(self.doorAnimation2.name), true);
		end;
		self:playAnimation(self.PanelDrehhebelState2.name, self.PanelDrehhebelState2.openSpeedScale, self:getAnimationTime(self.PanelDrehhebelState2.name), true);			
	end;
	
	if self.doorhigh == 2 then
		if dy > 2.5 and dy < 2.7 then
			self:playAnimation(self.doorAnimation.name, self.doorAnimation.openSpeedScale, self:getAnimationTime(self.doorAnimation.name), true);
		elseif dy > 2.8 and dy < 3 then
			self:playAnimation(self.doorAnimation1.name, self.doorAnimation1.openSpeedScale, self:getAnimationTime(self.doorAnimation1.name), true);
		elseif dy < 3.9 and dy > 3.7 then
			self:playAnimation(self.doorAnimation2.name, self.doorAnimation2.closeSpeedScale, self:getAnimationTime(self.doorAnimation2.name), true);
		end;
		self:playAnimation(self.PanelDrehhebelState3.name, self.PanelDrehhebelState3.openSpeedScale, self:getAnimationTime(self.PanelDrehhebelState3.name), true);			
	end;
	
	if self.doorhigh == 3 then	
		if dy > 2.5 and dy < 2.7 then
			self:playAnimation(self.doorAnimation.name, self.doorAnimation.openSpeedScale, self:getAnimationTime(self.doorAnimation.name), true);
		elseif dy > 2.8 and dy < 3 then
			self:playAnimation(self.doorAnimation1.name, self.doorAnimation1.openSpeedScale, self:getAnimationTime(self.doorAnimation1.name), true);
		elseif dy > 3.2 and dy < 3.4 then 
			self:playAnimation(self.doorAnimation2.name, self.doorAnimation2.openSpeedScale, self:getAnimationTime(self.doorAnimation2.name), true);
		end;	
		self:playAnimation(self.PanelDrehhebelState4.name, self.PanelDrehhebelState4.openSpeedScale, self:getAnimationTime(self.PanelDrehhebelState4.name), true);			
	end;
end;
 
function TebbeHS180:draw()
	if not self.hasInteractivControl then
		if self.HudRender then
			g_currentMission:addHelpButtonText(g_i18n:getText("HUD_OFF"), InputBinding.TEBBE_HUD_ONOFF);		
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("HUD_ON"), InputBinding.TEBBE_HUD_ONOFF);
		end;
	end;
	
	if self.isClient then	
		if self.HudRender then
			self.BedienboxHUD:render();
			if self.doorhigh == 0 then
				setTextBold(false);			
				renderText(0.105, 0.16, 0.02, "Rueckwand Stufe 0/3");	
				self.HUD_high_0:render();
			elseif self.doorhigh == 1 then
				setTextBold(false);					
				renderText(0.105, 0.16, 0.02, "Rueckwand Stufe 1/3");		
				self.HUD_high_1:render();
			elseif self.doorhigh == 2 then
				setTextBold(false);					
				renderText(0.105, 0.16, 0.02, "Rueckwand Stufe 2/3");	
				self.HUD_high_2:render();
			elseif self.doorhigh == 3 then
				setTextBold(false);					
				renderText(0.105, 0.16, 0.02, "Rueckwand Stufe 3/3");	
				self.HUD_high_3:render();
			end;
			local fillLevelNew = self.fillLevel / self.capacity * 100;
			local fillLevelPerCent = math.floor(fillLevelNew)
			setTextBold(false);					
			renderText(0.12, 0.18, 0.02, "Fuellstand "..fillLevelPerCent.." %");
			if self.isTurnedOn then
				self.HUD_turnOn_on:render();
			else
				self.HUD_turnOn_off:render();
			end;
			if self.HUD_less_1_HudRender then	
				self.HUD_less_1:render();
			end;
			if self.HUD_less_0_HudRender then
				self.HUD_less_0:render();
			end;
			if self.HUD_higher_0_HudRender then
				self.HUD_higher_0:render();
			end;
			if self.HUD_higher_1_HudRender then
				self.HUD_higher_1:render();
			end;
		end;
		
		if self.flapopen then
			if self.HudRender then
				self.HUD_Klappe_open:render();
			end;
			g_currentMission:addHelpButtonText(g_i18n:getText("flapAnimationclose"), InputBinding.TEBBE_flapanimation);
		else
			if self.HudRender then
				self.HUD_Klappe_close:render();
			end;
			g_currentMission:addHelpButtonText(g_i18n:getText("flapAnimationopen"), InputBinding.TEBBE_flapanimation);
		end;
		
		g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.TEBBE_doorhighMore).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.TEBBE_doorhighLess)..": Rueckwand Stufe "..self.doorhigh.."/3");

		
		if self.printWarningTime > self.time and self.fillLevel > 0 then
              g_currentMission:addWarning(g_i18n:getText("HAVETOOPEN"), 0.018, 0.033);
		end;
		if self.printWarningTimeIsEmpty > self.time then
              g_currentMission:addWarning(g_i18n:getText("ISEMPTY"), 0.018, 0.033);
		end;			
    end;
end;
 
function TebbeHS180:onDetach()
	Utils.setEmittingState(self.particleSystemStufe1, false);		
	Utils.setEmittingState(self.particleSystemStufe2, false);		
	Utils.setEmittingState(self.particleSystemStufe3, false);	
	Utils.setEmittingState(self.particleSystemMist, false);	
	Utils.setEmittingState(self.particleSystemWalzen, false);
end;

function TebbeHS180:onLeave()
	Utils.setEmittingState(self.particleSystemStufe1, false);		
	Utils.setEmittingState(self.particleSystemStufe2, false);		
	Utils.setEmittingState(self.particleSystemStufe3, false);	
	Utils.setEmittingState(self.particleSystemMist, false);	
	Utils.setEmittingState(self.particleSystemWalzen, false);
end;
 
function TebbeHS180:onDeactivate()
end;
  
function TebbeHS180:onDeactivateSounds()
end;
 
function TebbeHS180:setIsTurnedOn(isTurnedOn, noEventSend)
end;

Utils.loadStaticParticleSystem = function(xmlFile, psTable, baseString, linkNode, defaultEmittingState, filename, baseDirectory)
	--
	-- Static Particle System
	--
	-- Author:  Heady | www.planet-ls.de
	-- Date: 30.04.2011
	--
	--
	
	local defaultLinkNode = linkNode;
		if type(linkNode) == "table" then
			defaultLinkNode = linkNode[1].node;
		end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(linkNode, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);

	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = filename;
	end;
	if psFile == nil then
		return;
	end;
	psFile = Utils.getFilename(psFile, baseDirectory);  
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("Error: failed to load particle system " .. psFile);
		return;
	end	
	
	link(linkNode, rootNode)	

	local posString = getXMLString(xmlFile, baseString .. "#position");
	if posString ~= nil then
		local posX, posY, posZ = Utils.getVectorFromString(posString);
		setTranslation(rootNode, posX, posY, posZ);
	end;	
	local rotString = getXMLString(xmlFile, baseString .. "#rotation");
	if rotString ~= nil then
		local rotX, rotY, rotZ = Utils.getVectorFromString(rotString);
		rotX = Utils.degToRad(rotX);
		rotY = Utils.degToRad(rotY);
		rotZ = Utils.degToRad(rotZ);
		setRotation(rootNode, rotX, rotY, rotZ);
	end;

	--for i = getNumOfChildren(rootNode) - 1, 0, -1 do
	for i=1, getNumOfChildren(rootNode) do
		local child = getChildAt(rootNode, i-1);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 and getClassName(geometry) == "ParticleSystem" then
				table.insert(psTable, {geometry = geometry, shape = child});
				if defaultEmittingState ~= nil then
					setEmittingState(geometry, defaultEmittingState);
				end;
			end;
		end;
	end;

	return rootNode;
end;

function TebbeHS180:Supdate(dt)
	if self:getIsActiveForInput() then
		if self.nameVar == self.nameTebbe then
			if self.doorhigh == 0 then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
					self:setIsTurnedOn(not self.isTurnedOn);
				end;
			end;
		end;
		if self.nameVar == not self.nameTebbe then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				self:setIsTurnedOn(not self.isTurnedOn);
			end;
		end;
		if self.isTurnedOn and self.doorhigh == 0 then
			self.isTurnedOn = false;
			if self.spraySoundEnabled then
				stopSample(self.spraySound);
				self.spraySoundEnabled = false;
			end;
		end;
	end;
end;

function TebbeHS180:Sload(xmlFile)
	self.nameVar = getXMLString(xmlFile, "vehicle.name.de");
	self.nameTebbe = "TebbeHS180";
end;

Sprayer.update = Utils.appendedFunction(Sprayer.update, TebbeHS180.Supdate);
Sprayer.load = Utils.appendedFunction(Sprayer.load, TebbeHS180.Sload);