--
-- TurningLight
-- Specialization for a turning light for low config.
--
-- @author  Bayn ( www.tsforum3.com )
-- @date  27/09/09
--

TurningLight = {};

function TurningLight.prerequisitesPresent(specializations)
    return true
end;

function TurningLight:load(xmlFile)

	------ 		Define keys		  ------------

	self.keys = {};
	self.keysName = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
		self.keysName[inputName] = Utils.getNoNil(getXMLString(xmlFile, baseName.."#keyname"),"Touche ?");
        i = i+1;
    end;	
	
	
	------ Turning light's elements ----------
	
	self.TurningLight = {};
    self.TurningLight.rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.TurningLight#rotNode"));
    self.TurningLight.lightFace = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.TurningLight#lightFace"));
    self.TurningLight.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TurningLight#rotSpeed"), 1)/1000;

	
	------ Selfs ----------
	
	self.TurningLightOn = false;
		
end;

function TurningLight:delete()
end;

function TurningLight:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TurningLight:keyEvent(unicode, sym, modifier, isDown)

		if isDown and sym == self.keys.TL then
			self.TurningLightOn = not self.TurningLightOn;
		end;
end;

function TurningLight:update(dt)
		
		if self.TurningLightOn then
			rotate(self.TurningLight.rotNode, 0, dt*self.TurningLight.speed, 0);
			setVisibility(self.TurningLight.lightFace, true);
		else
			setVisibility(self.TurningLight.lightFace, false);
		end;
		
end;

function TurningLight:draw()
	if self.TurningLightOn then
		g_currentMission:addExtraPrintText(string.format("%s : Eteindre le gyrophare",self.keysName.TL));
	else
		g_currentMission:addExtraPrintText(string.format("%s : Allumer le gyrophare",self.keysName.TL));
	end;
end;

