Feux = {};

function Feux.prerequisitesPresent(specializations)
    return true
end;

function Feux:load(xmlFile)
	------ Feux D'arrt -----
	self.numBrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numBrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	
	self.brakelightsActive = false;

	------ Feux de recul
	self.numReverselights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.reverselights#count"), 0);
    self.reverselights = {};
    for i=1, self.numReverselights do
        local reverselightnamei = string.format("vehicle.reverselights.reverselight" .. "%d", i);
        self.reverselights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, reverselightnamei .. "#index"));
        setVisibility(self.reverselights[i], false);
    end;
	self.reverselightsActive = false;
end;

function Feux:delete()
end;

function Feux:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Feux:keyEvent(unicode, sym, modifier, isDown)
end;

function Feux:update(dt)
	-- Feux d'arrt
	if self.brakelightsActive then
		for i=1, self.numBrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive);
		end;
	else
		for i=1, self.numBrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive, false);
		end;
	end;
	-- Feux de recul
	if self.reverselightsActive then
		for i=1, self.numReverselights do
			local reverselight = self.reverselights[i];
			setVisibility(reverselight, self.reverselightsActive);
		end;
	else
		for i=1, self.numReverselights do
			local reverselight = self.reverselights[i];
			setVisibility(reverselight, self.reverselightsActive, false);
		end;
	end;
	if self.attacherVehicle then
		if self.attacherVehicle.movingDirection < 0 then
			self.reverselightsActive = true;
		else
			self.reverselightsActive = false;
		end;
	end;		
end;

function Feux:draw()
end;
function Feux:onBrake()
	if self.attacherVehicle.motor.speedLevel == 0 then	
		self.brakelightsActive = true;
    end;
end;

function Feux:onReleaseBrake()
	self.brakelightsActive = false;
end;