-- Waschbrstenscript by Blacky_BPG
-- 
-- 
-- 
-- 31.03.2013		V 2.0

WaschBox2 = {};
  
local WaschBox2_mt = Class(WaschBox2);
  
function WaschBox2.onCreate(id)
	g_currentMission:addUpdateable(WaschBox2:new(id));
end;
  
function WaschBox2:new(id, customMt)
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, WaschBox2_mt);
	end;

	local idx = Utils.indexToObject(id, getUserAttribute(id, "triggerID"));
	if idx ~= nil then
		instance.triggerId = idx
		addTrigger(idx, "triggerCallback", instance);
	else
		instance.triggerId = id;
		addTrigger(id, "triggerCallback", instance);
	end;

	instance.audio = Utils.indexToObject(id, getUserAttribute(id, "audio"));
	instance.buersteLinks = Utils.indexToObject(id, getUserAttribute(id, "buersteLinks"));
	instance.buersteRechts = Utils.indexToObject(id, getUserAttribute(id, "buersteRechts"));
	instance.buersteOben = Utils.indexToObject(id, getUserAttribute(id, "buersteOben"));
	instance.emitter1 = Utils.indexToObject(id, getUserAttribute(id, "emitter1"));
	instance.emitter2 = Utils.indexToObject(id, getUserAttribute(id, "emitter2"));
	instance.emitter3 = Utils.indexToObject(id, getUserAttribute(id, "emitter3"));
	instance.emitter4 = Utils.indexToObject(id, getUserAttribute(id, "emitter4"));
	instance.ltrans = Utils.getNoNil(getUserAttribute(id, "buersteLinksMax"),-3.0);
	instance.rtrans = Utils.getNoNil(getUserAttribute(id, "buersteRechtsMax"),3.0);
	instance.otrans = Utils.getNoNil(getUserAttribute(id, "buersteObenMax"),6.0);
	instance.cleanTime = Utils.getNoNil(getUserAttribute(id, "cleanTime"),10) * 1000;
	instance.rotationSpeed = Utils.getNoNil(getUserAttribute(id, "rotationSpeed"),100) / 100;
	local rootNode = getChild(id, "buersten")
	instance.animCharSet = 0;
	if rootNode ~= nil then
		instance.animCharSet = getAnimCharacterSet(rootNode);
		if instance.animCharSet ~= 0 then
			local clipSource = getUserAttribute(id, "animationClip");
			if clipSource ~= nil then
				instance.clip = getAnimClipIndex(instance.animCharSet, clipSource);
				if instance.clip ~= nil then
					if instance.clip >= 0 then
						assignAnimTrackClip(instance.animCharSet, 0, instance.clip);
						setAnimTrackLoopState(instance.animCharSet, 0, true);
						setAnimTrackSpeedScale(instance.animCharSet, 0, instance.rotationSpeed);
						instance.speedScale = 1.0;
						instance.animDuration = getAnimClipDuration(instance.animCharSet, instance.clip);
					end;
				end;
			end;
		end;
	end;

	instance.isEnabled = true;
	instance.trackTime = 0;
	instance.lastTrackTime = 0;

	if g_currentMission.washTriggers == nil then
		g_currentMission.washTriggers = {};
	end;
	local triggertable = {};
	triggertable.id = instance.triggerId;
	triggertable.trigger1 = false;
	triggertable.trigger2 = false;
	triggertable.trigger3 = false;
	table.insert(g_currentMission.washTriggers, triggertable);

	setVisibility(self.audio, false);
	setVisibility(self.emitter1, false);
	setVisibility(self.emitter2, false);
	setVisibility(self.emitter3, false);
	setVisibility(self.emitter4, false);
	
	instance.lRdy = 0;
	instance.rRdy = 0;
	instance.oRdy = 0;

	instance.count = 0;
	instance.vehiclesInTrigger = {};

	return instance;
end;
  
function WaschBox2:delete()
	removeTrigger(self.triggerId);
end;
  
function WaschBox2:update(dt)
	if self.count > 0 then
		for x,y in pairs(g_currentMission.washTriggers) do
			if y.id == self.triggerId then
				self.lRdy = y.trigger1;
				self.rRdy = y.trigger2;
				self.oRdy = y.trigger3;
			end;
		end;
		if table.getn(self.vehiclesInTrigger) > 0 then
			for a, b in pairs(self.vehiclesInTrigger) do
				local vehicle = g_currentMission.nodeToVehicle[b];
				if vehicle ~= nil then
					local ds = vehicle.dirtScale;
					if ds ~= nil then
						if self.lRdy == true and self.rRdy == true and self.oRdy == true then
							local scale = Utils.getMovedLimitedValues({vehicle.dirtScale}, {1}, {0}, 1, self.cleanTime, dt, true);
							vehicle.dirtScale = scale[1];
						end;
						if vehicle.dirtScale >= 0.02 then
							self.x,self.y,self.z = getTranslation(self.buersteLinks);
							local dist = (self.ltrans + 3);
							if self.z < dist and self.lRdy == false then
								dist = self.z + 0.01;
								setTranslation(self.buersteLinks, self.x, self.y, dist);
							end;
							self.x,self.y,self.z = getTranslation(self.buersteRechts);
							local dist = (self.rtrans - 3);
							if self.z > dist and self.rRdy == false then
								dist = self.z - 0.01;
								setTranslation(self.buersteRechts, self.x, self.y, dist);
							end;
							self.x,self.y,self.z = getTranslation(self.buersteOben);
							local dist = (self.otrans - 4);
							if self.y > dist and self.oRdy == false then
								dist = self.y - 0.01;
								setTranslation(self.buersteOben, self.x, dist, self.z);
							end;
						else
							table.remove(self.vehiclesInTrigger,a);
						end;
					else
						table.remove(self.vehiclesInTrigger,a);
					end;
				else
					table.remove(self.vehiclesInTrigger,a);
				end;
			end;
			if self.lRdy == true and self.rRdy == true and self.oRdy == true then
				setVisibility(self.audio, true);
				setVisibility(self.emitter1, true);
				setVisibility(self.emitter2, true);
				setVisibility(self.emitter3, true);
				setVisibility(self.emitter4, true);
				if self.animDuration ~= nil then
					if self.trackTime < 1 then 
						self.trackTime = 0;
					end;
					if self.trackTime >= self.animDuration then
						self.trackTime = 0;
					end;
					self.trackTime = self.trackTime +10*self.speedScale;
					if self.lastTrackTime ~= self.trackTime then
						enableAnimTrack(self.animCharSet, self.clip);
						setAnimTrackSpeedScale(self.animCharSet, 0, self.rotationSpeed);
						self.lastTrackTime = self.trackTime;
					end;
				end;
			end;
		else
			setVisibility(self.audio, false);
			setVisibility(self.emitter1, false);
			setVisibility(self.emitter2, false);
			setVisibility(self.emitter3, false);
			setVisibility(self.emitter4, false);
			disableAnimTrack(self.animCharSet, self.clip);
			self.x,self.y,self.z = getTranslation(self.buersteLinks);
			if self.z > self.ltrans then
				local dist = self.z - 0.02;
				setTranslation(self.buersteLinks, self.x, self.y, dist);
				self.lRdy = false;
			end;
			self.x,self.y,self.z = getTranslation(self.buersteRechts);
			if self.z < self.rtrans then
				local dist = self.z + 0.02;
				setTranslation(self.buersteRechts, self.x, self.y, dist);
				self.rRdy = false;
			end;
			self.x,self.y,self.z = getTranslation(self.buersteOben);
			if self.y < self.otrans then
				local dist = self.y + 0.02;
				setTranslation(self.buersteOben, self.x, dist, self.z);
				self.oRdy = false;
			end;
			self.count = 0;
		end;
	else
		setVisibility(self.audio, false);
		setVisibility(self.emitter1, false);
		setVisibility(self.emitter2, false);
		setVisibility(self.emitter3, false);
		setVisibility(self.emitter4, false);
		disableAnimTrack(self.animCharSet, self.clip);
		self.x,self.y,self.z = getTranslation(self.buersteLinks);
		if self.z > self.ltrans then
			local dist = self.z - 0.02;
			setTranslation(self.buersteLinks, self.x, self.y, dist);
			self.lRdy = false;
		end;
		self.x,self.y,self.z = getTranslation(self.buersteRechts);
		if self.z < self.rtrans then
			local dist = self.z + 0.02;
			setTranslation(self.buersteRechts, self.x, self.y, dist);
			self.rRdy = false;
		end;
		self.x,self.y,self.z = getTranslation(self.buersteOben);
		if self.y < self.otrans then
			local dist = self.y + 0.02;
			setTranslation(self.buersteOben, self.x, dist, self.z);
			self.oRdy = false;
		end;
	end;
end;
  
function WaschBox2:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and self.isEnabled then
		local doInsert = true;
		if table.getn(self.vehiclesInTrigger) > 0 then
			for a, b in pairs(self.vehiclesInTrigger) do
				if b == otherId then
					doInsert = false;
				end;
			end;
		end;
		if doInsert == true then
			table.insert(self.vehiclesInTrigger, otherId);
			self.count = self.count + 1;
		end;
	elseif onLeave then
		if table.getn(self.vehiclesInTrigger) > 0 then
			for a, b in pairs(self.vehiclesInTrigger) do
				if b == otherId then
					table.remove(self.vehiclesInTrigger,a);
				end;
			end;
		end;
		self.count = self.count - 1;
		if self.count < 0 then
			self.count = 0;
		end;
	end; 
end;
    
g_onCreateUtil.addOnCreateFunction("WaschBox2OnCreate", WaschBox2.onCreate);

--------------------------------------
--------------------------------------
---------- Contact Reporter ----------
--------------------------------------
  
WaschBoxContact = {};
  
local WaschBoxContact_mt = Class(WaschBoxContact);
  
function WaschBoxContact.onCreate(id)
	g_currentMission:addUpdateable(WaschBoxContact:new(id));
end;
  
function WaschBoxContact:new(id, customMt)
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, WaschBoxContact_mt);
	end;

	instance.parent = nil;
	local parent = nil;
	local parent1 = getParent(id);
	if parent1 ~= nil then
		local parent2 = getParent(parent1);
		if parent2 ~= nil then
			local idx = Utils.indexToObject(parent2, getUserAttribute(parent2, "triggerID"));
			if idx ~= nil then
				parent = idx;
			else
				print("  ERROR: Trigger "..tostring(id).." can't found valid Parent, Trigger is not available !");
				return nil;
			end;
		end;
	end;

	instance.myself = getUserAttribute(id, "myself");
	instance.parent = parent;

	instance.triggerId = id;
	addTrigger(id, "triggerCallback", instance);

	instance.isEnabled = true;

	instance.count = 0;
	instance.vehiclesInTrigger = {};

	return instance;
end;
  
function WaschBoxContact:delete()
	removeTrigger(self.triggerId);
end;
  
function WaschBoxContact:update(dt)
	if self.count > 0 then
		for x,y in pairs(g_currentMission.washTriggers) do
			if y.id == self.parent then
				if table.getn(self.vehiclesInTrigger) > 0 then
					if self.myself == 1 then
						y.trigger1 = true;
					elseif self.myself == 2 then
						y.trigger2 = true;
					elseif self.myself == 3 then
						y.trigger3 = true;
					end;
				else
					if self.myself == 1 then
						y.trigger1 = false;
					elseif self.myself == 2 then
						y.trigger2 = false;
					elseif self.myself == 3 then
						y.trigger3 = false;
					end;
				end;
			end;
		end;
	else
		for x,y in pairs(g_currentMission.washTriggers) do
			if y.id == self.parent then
				if self.myself == 1 then
					y.trigger1 = false;
				elseif self.myself == 2 then
					y.trigger2 = false;
				elseif self.myself == 3 then
					y.trigger3 = false;
				end;
			end;
		end;
	end;
end;
  
function WaschBoxContact:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and self.isEnabled then
		table.insert(self.vehiclesInTrigger, otherId);
		self.count = self.count + 1;
	elseif onLeave then
		if table.getn(self.vehiclesInTrigger) > 0 then
			for a, b in pairs(self.vehiclesInTrigger) do
				if b == otherId then
					table.remove(self.vehiclesInTrigger,i);
				end;
			end;
		end;
		self.count = self.count - 1;
		if self.count < 0 then
			self.count = 0;
		end;
	end; 
end;
    
g_onCreateUtil.addOnCreateFunction("WaschBoxContactOnCreate", WaschBoxContact.onCreate);

