--
-- BlicklingHallFarm
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

BlicklingHallFarm = {}

local BlicklingHallFarm_mt = Class(BlicklingHallFarm, Mission00);


function BlicklingHallFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = BlicklingHallFarm_mt;
    end;
    local self = BlicklingHallFarm:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function BlicklingHallFarm:delete()
    BlicklingHallFarm:superClass().delete(self);
end;

function BlicklingHallFarm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map01.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function BlicklingHallFarm:loadMap01Finished(node, arguments)

	self.terrainDetailAngleNumChannels = 8; -- durch die gewnschte Anzahl Channels ersetzen
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("BlicklingHallFarm.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -144.0984, 499.85849, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 46.27344, 546.54846, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 49.24879, 492.41614, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -183.28349, 534.75128, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 97.4641, 5.82973, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
   	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 441.45355, -287.73209, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -479.43213, -246.52306, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Sugar Factory
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -492.67307, 285.02692, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -457.30634 , -284.54828, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 218.81526, -27.47001, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 351.5123, -528.60938, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 452.67502, -193.05112, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), 531.20935, 547.95892, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    BlicklingHallFarm:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    self:finishLoadingTask();
end;

function BlicklingHallFarm:onStartMission()
    BlicklingHallFarm:superClass().onStartMission(self);
end;

function BlicklingHallFarm:mouseEvent(posX, posY, isDown, isUp, button)
    BlicklingHallFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BlicklingHallFarm:keyEvent(unicode, sym, modifier, isDown)
    BlicklingHallFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BlicklingHallFarm:update(dt)
    BlicklingHallFarm:superClass().update(self, dt);
end;

function BlicklingHallFarm:draw()
    BlicklingHallFarm:superClass().draw(self);
end;
function MyFieldDefinitionUpdate(self, superFunc, dt)
  -- Do not call the base update() function, in attempt at making fields buy-icons not rotate.
  -- May cause other problems though.
  --superFunc(self,dt)
end
FieldDefinition.update = Utils.overwrittenFunction(FieldDefinition.update, MyFieldDefinitionUpdate);