--
-- PowerShaft
-- Specialization for PowerShaft
--
-- @author  Manuel Leithner
-- @date  26/07/09
--
-- edit by modelleicher for LS13
-- @date 21.03.2013
-- addet optional animation and realistic animation features

PowerShaftLS13 = {};

function PowerShaftLS13.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function PowerShaftLS13:load(xmlFile)

	-- optional powershaft animation 
	self.optionalRealisticPowershaft = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.powerShaft#optionalRealisticPowershaft"));
	self.hinge1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft.optionalRealisticPowershaft#hinge1index"));
	self.hinge2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft.optionalRealisticPowershaft#hinge2index"));
	self.h2parent = getParent(self.hinge2);
	self.h2SV = {};
	self.h2SV.tx, self.h2SV.ty, self.h2SV.tz = getTranslation(self.hinge2);
	self.h2SV.rx, self.h2SV.ry, self.h2SV.rz = getRotation(self.hinge2);
	
	-- optional powershaft rotation animation
	self.optionalRotAnimation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.powerShaft#optionalRotAnimation"));
	self.rotHinge1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft.optionalRotAnimation#rotHinge1"));
	self.rotHinge2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft.optionalRotAnimation#rotHinge2"));
	self.rotShaft1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft.optionalRotAnimation#rotShaft1"));
	self.rotShaft2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft.optionalRotAnimation#rotShaft2"));
	self.RArotSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.powerShaft.optionalRotAnimation#rotSpeed"), 1);
	
	-- alternative use old mode of FS11 Powershaft
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	self.powerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
	x,y,z = getTranslation(self.powerShaft.part);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	if self.optionalRealisticPowershaft then
		local ax, ay, az = getWorldTranslation(self.powerShaft.part);
		local bx, by, bz = getWorldTranslation(self.hinge2);		
		self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	else
		local ax, ay, az = getWorldTranslation(self.powerShaft.part);
		local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
		self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	end;
	
	self.attacherVehiclePowerShaft = nil;
	self.doJointSearch = false;
	self.usePowerShaftPasstrought = nil; -- addet ability to use Fastcoupler or "Ackerschiene"
	
end;

function PowerShaftLS13:delete()
end;

function PowerShaftLS13:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowerShaftLS13:keyEvent(unicode, sym, modifier, isDown)
end;

function PowerShaftLS13:update(dt)
	
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];	
				if joint.powerShaftAttacher ~= nil then
					self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
					break;	
				end;
				if self.attacherVehiclePowerShaft == nil then -- use giants power shaft node if vehicle has no powershaft attacher
					if joint.ptoOutput ~= nil and joint.ptoOutput.node ~= nil then
						self.attacherVehiclePowerShaft = joint.ptoOutput.node;
						break;
					end;
				end;
				-- passtrough by "Ackerschiene" or Fastcoupler
				if self.attacherVehicle.powerShaftPasstrought == true then
					for i=1, table.getn(self.attacherVehicle.attacherVehicle.attachedImplements) do
						if self.attacherVehicle.attacherVehicle.attachedImplements[i].object == self.attacherVehicle then
							local index = self.attacherVehicle.attacherVehicle.attachedImplements[i].jointDescIndex;
							local joint = self.attacherVehicle.attacherVehicle.attacherJoints[index];	
							if joint.powerShaftAttacher ~= nil then
								self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
								self.usePowerShaftPasstrought = true;
								break;	
							end;
							if self.attacherVehiclePowerShaft == nil then -- use giants power shaft node if vehicle has no powershaft attacher
								if joint.ptoOutput ~= nil and joint.ptoOutput.node ~= nil then
									self.attacherVehiclePowerShaft = joint.ptoOutput.node;
									self.usePowerShaftPasstrought = true;
									break;
								end;
							end;	
						end;
					end;
				end;
			end;
		end;
		self.doJointSearch = false;
	end;
	
	if self:getIsActive() then		
		if self.attacherVehiclePowerShaft ~= nil then		
			if self.optionalRealisticPowershaft == true then	 -- Animation for realisticPowershaft
				link(self.attacherVehiclePowerShaft, self.hinge2);
				setTranslation(self.hinge2, 0, 0, 0.04);
				setRotation(self.hinge2, 0, Utils.degToRad(180), 0);
				local ax, ay, az = getWorldTranslation(self.powerShaft.node);
				local bx, by, bz = getWorldTranslation(self.hinge2);
				
				local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
				setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);					
			
			else
				local ax, ay, az = getWorldTranslation(self.powerShaft.node); -- or use old FS11 Methode
				local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
				local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
				setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);	
			end;
			
			if self.optionalRotAnimation then  -- Optional rotationAnimation
				if self.isTurnedOn then  -- edit this variable if you are using an attachable that reacts not to self.isTurnedOn
					local speed = dt*0.006*self.RArotSpeed;
					if self.rotHinge1 ~= nil then    -- all 4 parts can be used, but there's no error if only 3, 2 or 1 wrote in XML
						rotate(self.rotHinge1, 0, 0, speed);
					end;
					if self.rotHinge2 ~= nil then
						rotate(self.rotHinge2, 0, 0, speed);
					end;
					if self.rotShaft1 ~= nil then
						rotate(self.rotShaft1, 0, 0, speed);
					end;
					if self.rotShaft2 ~= nil then
						rotate(self.rotShaft2, 0, 0, speed);
					end;
				end;
			end;
		end;	
	else
		if self.usePowerShaftPasstrought then  -- for the use wirth "Ackerschiene" or Fastcoupler
			if self.attacherVehicle.attacherVehicle == nil then -- sets powershaft to default if attachervehicle.attachervehicle is detached
				if self.optionalRealisticPowershaft then
					link(self.h2parent, self.hinge2);
					setTranslation(self.hinge2, self.h2SV.tx, self.h2SV.ty, self.h2SV.tz);
					setRotation(self.hinge2, self.h2SV.rx, self.h2SV.ry, self.h2SV.rz);					
				end;
				if self.optionalRotAnimation then 
					if self.rotHinge1 ~= nil then
						setRotation(self.rotHinge1, 0, 0, 0);
					end;
					if self.rotHinge2 ~= nil then
						setRotation(self.rotHinge2, 0, 0, 0);
					end;
					if self.rotShaft1 ~= nil then
						setRotation(self.rotShaft1, 0, 0, 0);
					end;
					if self.rotShaft2 ~= nil then
						setRotation(self.rotShaft2, 0, 0, 0);
					end;
				end;
				setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
				setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
				self.attacherVehiclePowerShaft = nil;	
				self.usePowerShaftPasstrought = nil;	
			end;
		end;
	end;
	
	
end;

function PowerShaftLS13:draw()
end;

function PowerShaftLS13:onAttach(attacherVehicle)
	self.doJointSearch = true;
end;

function PowerShaftLS13:onDetach()
	if self.optionalRealisticPowershaft then
		link(self.h2parent, self.hinge2);
		setTranslation(self.hinge2, self.h2SV.tx, self.h2SV.ty, self.h2SV.tz);
		setRotation(self.hinge2, self.h2SV.rx, self.h2SV.ry, self.h2SV.rz);	
	end;
	if self.optionalRotAnimation then 
		if self.rotHinge1 ~= nil then
			setRotation(self.rotHinge1, 0, 0, 0);
		end;
		if self.rotHinge2 ~= nil then
			setRotation(self.rotHinge2, 0, 0, 0);
		end;
		if self.rotShaft1 ~= nil then
			setRotation(self.rotShaft1, 0, 0, 0);
		end;
		if self.rotShaft2 ~= nil then
			setRotation(self.rotShaft2, 0, 0, 0);
		end;
	end;	
	setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
	setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
	self.usePowerShaftPasstrought = nil;
end;