--
-- Brimont
-- Specialization for Brimont trailer.
--
-- @author  	Benjamin Biot (J&B Modding)
-- @version 	v0.1 Beta 
--			v1.0 yet to come in "Maupu" trailer pack			
-- @date  		25/08/2011
--

Brimont = {}

function Brimont.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Brimont:load(xmlFile)
	self.setAddedParts = SpecializationUtil.callSpecializationsFunction("setAddedParts");
	
	--added parts
    self.sugarbeetPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sugarbeetPart#index"));
    self.defaultPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.defaultPart#index"));
    self.doorPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.doorPart#index"));
	
	setVisibility(self.defaultPart,true);
	setVisibility(self.doorPart,true);
	setVisibility(self.sugarbeetPart,false);	
	
	self.currentPart = 1;
end;

function Brimont:delete()
end;

function Brimont:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Brimont:keyEvent(unicode, sym, modifier, isDown)
end;

function Brimont:readStream(streamId, connection)
    local currentPart = streamReadInt16(streamId);
    self:setAddedParts(currentPart, false);
end;

function Brimont:writeStream(streamId, connection)
	streamWriteInt16(streamId, self.currentPart);
end;

function Brimont:readUpdateStream(streamId, timestamp, connection)
end;

function Brimont:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Brimont:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				if self.fillLevel <= 0 then
					if self.currentPart > 1 then
						self.currentPart = 0;
					else
						self.currentPart = self.currentPart +1;
					end;
					self:setAddedParts(self.currentPart);
				end;
			end;
		end;
	end;
end;

function Brimont:updateTick(dt)
	if self.fillLevel > 0 then
		if self.currentFillType == Fillable.FILLTYPE_MANURE then
			self:setAddedParts(0);
		elseif self.currentFillType == Fillable.FILLTYPE_SUGARBEET then
			self:setAddedParts(2);
		else
			if self.currentPart ~= 1 then
				self:setAddedParts(1);
			end;
		end;
	end;
end;

function Brimont:draw()
	if self.fillLevel <= 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("MANAGE_EXTRAPARTS"), InputBinding.LOWER_IMPLEMENT);
	end;
end;

function Brimont:setAddedParts(currentPart, noEventSend)
	AddedPartEvent.sendEvent(self, currentPart, noEventSend);	
	if currentPart == 0 then -- manure
		setVisibility(self.defaultPart,false);
		setVisibility(self.doorPart,false);
		setVisibility(self.sugarbeetPart,false);		
	elseif currentPart == 1 then -- default 
		setVisibility(self.defaultPart,true);
		setVisibility(self.doorPart,true);
		setVisibility(self.sugarbeetPart,false);	
	elseif currentPart == 2 then -- sugarbeet
		setVisibility(self.defaultPart,false);
		setVisibility(self.doorPart,true);
		setVisibility(self.sugarbeetPart,true);
	end;
end;

function Brimont:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local currentPart = Utils.getNoNil(getXMLInt(xmlFile, key.."#currentPartVisible"), 1);		
		self:setAddedParts(currentPart, true);
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function Brimont:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'currentPartVisible="'.. tostring(self.currentPart) .. '"';
    return attributes, nil;
end;
