AddedPartEvent = {};
AddedPartEvent_mt = Class(AddedPartEvent, Event);

InitEventClass(AddedPartEvent, "AddedPartEvent");

function AddedPartEvent:emptyNew()
    local self = Event:new(AddedPartEvent_mt);
    self.className="AddedPartEvent";
    return self;
end;

function AddedPartEvent:new(vehicle, currentPart)
    local self = AddedPartEvent:emptyNew()
    self.vehicle = vehicle;
	self.currentPart = currentPart;
    return self;
end;

function AddedPartEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.currentPart = streamReadInt16(streamId);	
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function AddedPartEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt16(streamId, self.currentPart);
end;

function AddedPartEvent:run(connection)
	self.vehicle:setAddedParts(self.currentPart, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(AddedPartEvent:new(self.vehicle, self.currentPart), nil, connection, self.vehicle);
	end;
end;

function AddedPartEvent.sendEvent(vehicle, currentPart, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AddedPartEvent:new(vehicle, currentPart), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(AddedPartEvent:new(vehicle, currentPart));
		end;
	end;
end;