--
-- anim1
-- 
--
-- @author  Mr.F
-- @date  30/11/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

anim1 = {};

function anim1.prerequisitesPresent(specializations)
    return true;
end;

function anim1:load(xmlFile)
		self.doRotateRight = false;
		self.doRotateLeft = false;	
		self.startMoveDirection =0;
		self.startAnimTime = 0;
		self.kippen = 0;
        self.animDuration =  Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animParts.part1#duration"));     
        self.animSpeed =  Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animParts.part1#speedMultiplier"));   
		self.entry = {};
		local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animParts.part1#rootNode"));
		self.entry.animCharSet = 0;
		if rootNode ~= nil then
			self.entry.animCharSet = getAnimCharacterSet(rootNode);
			if self.entry.animCharSet ~= 0 then
				local clip = getAnimClipIndex(self.entry.animCharSet, getXMLString(xmlFile, "vehicle.animParts.part1#animationClip"));
				if clip >= 0 then
					assignAnimTrackClip(self.entry.animCharSet, 0, clip);
					setAnimTrackLoopState(self.entry.animCharSet, 0, false);
					self.entry.animDuration = getAnimClipDuration(self.entry.animCharSet, clip);
				end;
			end;
		end;
end;

function anim1:delete()
end;

function anim1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function anim1:keyEvent(unicode, sym, modifier, isDown)
end;

function anim1:draw()
   
     g_currentMission:addHelpButtonText(g_i18n:getText("SILAGEWAGON_OPEN"),InputBinding.SILAGEWAGON_OPEN);
     g_currentMission:addHelpButtonText(g_i18n:getText("SILAGEWAGON_CLOSE"),InputBinding.SILAGEWAGON_CLOSE);
	end;
function anim1:update(dt)
    if self.kippen < 0 then 
       self.kippen = 0;
	end;
    if self.kippen > self.animDuration then 
      self.kippen = self.animDuration;

	end;
    if (InputBinding.isPressed(InputBinding.SILAGEWAGON_OPEN) and self:getIsActiveForInput())  then
        self.kippen = self.kippen +(10*self.animSpeed);
        enableAnimTrack(self.entry.animCharSet, 0);
        setAnimTrackTime(self.entry.animCharSet, 0, self.kippen, true);
        disableAnimTrack(self.entry.animCharSet, 0);
    end;
	if (InputBinding.isPressed(InputBinding.SILAGEWAGON_CLOSE) and self:getIsActiveForInput())  then
        self.kippen = self.kippen -(10*self.animSpeed);
        enableAnimTrack(self.entry.animCharSet, 0);
        setAnimTrackTime(self.entry.animCharSet, 0, self.kippen, true);
        disableAnimTrack(self.entry.animCharSet, 0);
    end;
end;

function anim1:onStartTip(currentTipTrigger)
 
    g_currentMission.allowSteerableMoving = false;
    g_currentMission.fixedCamera = false;
end;